/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.BaseJetCryptCodecHandler;
import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.CodecHandler;
import com.healthmarketscience.jackcess.DefaultCodecProvider;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.params.KeyParameter;

public class JetCryptCodecHandler
extends BaseJetCryptCodecHandler {
    static final int ENCODING_KEY_LENGTH = 4;

    JetCryptCodecHandler(PageChannel channel, byte[] encodingKey) {
        super(channel, encodingKey);
    }

    public static CodecHandler create(PageChannel channel) throws IOException {
        ByteBuffer buffer = JetCryptCodecHandler.readHeaderPage(channel);
        JetFormat format = channel.getFormat();
        byte[] encodingKey = ByteUtil.getBytes((ByteBuffer)buffer, (int)format.OFFSET_ENCODING_KEY, (int)4);
        return JetCryptCodecHandler.isBlankKey(encodingKey) ? DefaultCodecProvider.DUMMY_HANDLER : new JetCryptCodecHandler(channel, encodingKey);
    }

    public boolean canEncodePartialPage() {
        return true;
    }

    protected KeyParameter computeCipherParams(int pageNumber) {
        return new KeyParameter(this.getEncodingKey(pageNumber));
    }

    protected int getMaxEncodedPage() {
        return Integer.MAX_VALUE;
    }
}

