/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Cast;
import com.headius.invokebinder.transform.Catch;
import com.headius.invokebinder.transform.Collect;
import com.headius.invokebinder.transform.Convert;
import com.headius.invokebinder.transform.Drop;
import com.headius.invokebinder.transform.Filter;
import com.headius.invokebinder.transform.FilterReturn;
import com.headius.invokebinder.transform.Fold;
import com.headius.invokebinder.transform.Insert;
import com.headius.invokebinder.transform.Permute;
import com.headius.invokebinder.transform.Spread;
import com.headius.invokebinder.transform.Transform;
import com.headius.invokebinder.transform.TryFinally;
import com.headius.invokebinder.transform.Varargs;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class Binder {
    private final Logger logger = Logger.getLogger("Invoke Binder");
    private final List<Transform> transforms = new ArrayList<Transform>();
    private final List<MethodType> types = new ArrayList<MethodType>();
    private final MethodType start;
    private final MethodHandles.Lookup lookup;

    public Binder(MethodType start) {
        this.start = start;
        this.types.add(0, start);
        this.lookup = MethodHandles.publicLookup();
    }

    public Binder(MethodHandles.Lookup lookup, MethodType start) {
        this.start = start;
        this.types.add(0, start);
        this.lookup = lookup;
    }

    public Binder(Binder source) {
        this.start = source.start;
        this.types.addAll(source.types);
        this.transforms.addAll(source.transforms);
        this.lookup = source.lookup;
    }

    public Binder(MethodHandles.Lookup lookup, Binder source) {
        this.start = source.start;
        this.types.addAll(source.types);
        this.transforms.addAll(source.transforms);
        this.lookup = lookup;
    }

    public Binder(Binder source, Transform transform) {
        this.start = source.start;
        this.types.addAll(source.types);
        this.transforms.addAll(source.transforms);
        this.add(transform);
        this.lookup = source.lookup;
    }

    public Binder(Binder source, Transform transform, MethodType type) {
        this.start = source.start;
        this.types.addAll(source.types);
        this.transforms.addAll(source.transforms);
        this.add(transform, type);
        this.lookup = source.lookup;
    }

    public static Binder from(MethodType start) {
        return new Binder(start);
    }

    public static Binder from(MethodHandles.Lookup lookup, MethodType start) {
        return new Binder(lookup, start);
    }

    public static Binder from(Class<?> returnType) {
        return Binder.from(MethodType.methodType(returnType));
    }

    public static Binder from(MethodHandles.Lookup lookup, Class<?> returnType) {
        return Binder.from(lookup, MethodType.methodType(returnType));
    }

    public static Binder from(Class<?> returnType, Class<?>[] argTypes) {
        return Binder.from(MethodType.methodType(returnType, argTypes));
    }

    public static Binder from(MethodHandles.Lookup lookup, Class<?> returnType, Class<?>[] argTypes) {
        return Binder.from(lookup, MethodType.methodType(returnType, argTypes));
    }

    public static Binder from(Class<?> returnType, Class<?> argType0, Class<?> ... argTypes) {
        return Binder.from(MethodType.methodType(returnType, argType0, argTypes));
    }

    public static Binder from(MethodHandles.Lookup lookup, Class<?> returnType, Class<?> argType0, Class<?> ... argTypes) {
        return Binder.from(lookup, MethodType.methodType(returnType, argType0, argTypes));
    }

    public static Binder from(Binder start) {
        return new Binder(start);
    }

    public static Binder from(MethodHandles.Lookup lookup, Binder start) {
        return new Binder(lookup, start);
    }

    public Binder to(Binder other) {
        assert (this.type().equals((Object)other.start));
        Binder newBinder = new Binder(this);
        ListIterator<Transform> iter = other.transforms.listIterator(other.transforms.size());
        while (iter.hasPrevious()) {
            Transform t = iter.previous();
            newBinder.add(t);
        }
        return newBinder;
    }

    public Binder withLookup(MethodHandles.Lookup lookup) {
        return Binder.from(lookup, this);
    }

    private void add(Transform transform) {
        this.add(transform, transform.down(this.types.get(0)));
    }

    private void add(Transform transform, MethodType target) {
        this.types.add(0, target);
        this.transforms.add(0, transform);
    }

    public MethodType type() {
        return this.types.get(0);
    }

    public Binder printType(PrintStream ps) {
        ps.println(this.types.get(0));
        return this;
    }

    public Binder printType() {
        return this.printType(System.out);
    }

    public Binder logType() {
        this.logger.info(this.types.get(0).toString());
        return this;
    }

    public Binder insert(int index, boolean value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, byte value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, short value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, char value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, int value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, long value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, float value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, double value) {
        return new Binder(this, new Insert(index, value));
    }

    public Binder insert(int index, Object ... values) {
        return new Binder(this, new Insert(index, values));
    }

    public Binder insert(int index, Class<?> type, Object value) {
        return new Binder(this, new Insert(index, new Class[]{type}, value));
    }

    public Binder insert(int index, Class<?>[] types, Object ... values) {
        return new Binder(this, new Insert(index, types, values));
    }

    public Binder append(boolean value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(byte value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(short value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(char value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(int value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(long value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(float value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(double value) {
        return new Binder(this, new Insert(this.type().parameterCount(), value));
    }

    public Binder append(Object ... values) {
        return new Binder(this, new Insert(this.type().parameterCount(), values));
    }

    public Binder prepend(boolean value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(byte value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(short value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(char value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(int value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(long value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(float value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(double value) {
        return new Binder(this, new Insert(0, value));
    }

    public Binder prepend(Object ... values) {
        return new Binder(this, new Insert(0, values));
    }

    public Binder append(Class<?> type, Object value) {
        return new Binder(this, new Insert(this.type().parameterCount(), new Class[]{type}, value));
    }

    public Binder append(Class<?>[] types, Object ... values) {
        return new Binder(this, new Insert(this.type().parameterCount(), types, values));
    }

    public Binder prepend(Class<?> type, Object value) {
        return new Binder(this, new Insert(0, new Class[]{type}, value));
    }

    public Binder prepend(Class<?>[] types, Object ... values) {
        return new Binder(this, new Insert(0, types, values));
    }

    public Binder drop(int index) {
        return this.drop(index, 1);
    }

    public Binder drop(int index, int count) {
        return new Binder(this, new Drop(index, Arrays.copyOfRange(this.type().parameterArray(), index, index + count)));
    }

    public Binder dropLast() {
        return this.dropLast(1);
    }

    public Binder dropLast(int count) {
        assert (count <= this.type().parameterCount());
        return this.drop(this.type().parameterCount() - count, count);
    }

    public Binder dropFirst() {
        return this.dropFirst(1);
    }

    public Binder dropFirst(int count) {
        assert (count <= this.type().parameterCount());
        return this.drop(0, count);
    }

    public Binder dropAll() {
        return this.drop(0, this.type().parameterCount());
    }

    public Binder convert(MethodType target) {
        return new Binder(this, new Convert(this.type()), target);
    }

    public Binder convert(Class<?> returnType, Class<?> ... argTypes) {
        return new Binder(this, new Convert(this.type()), MethodType.methodType(returnType, argTypes));
    }

    public Binder cast(MethodType type) {
        return new Binder(this, new Cast(this.type()), type);
    }

    public Binder cast(Class<?> returnType, Class<?> ... argTypes) {
        return new Binder(this, new Cast(this.type()), MethodType.methodType(returnType, argTypes));
    }

    public Binder castVirtual(Class<?> returnType, Class<?> firstType, Class<?> ... restTypes) {
        return new Binder(this, new Cast(this.type()), MethodType.methodType(returnType, firstType, restTypes));
    }

    public Binder spread(Class<?> ... spreadTypes) {
        if (spreadTypes.length == 0) {
            return this.dropLast();
        }
        return new Binder(this, new Spread(this.type(), spreadTypes));
    }

    public Binder spread(int count) {
        if (count == 0) {
            return this.dropLast();
        }
        TypeDescriptor.OfField aryType = this.type().parameterType(this.type().parameterCount() - 1);
        assert (((Class)aryType).isArray());
        Object[] spreadTypes = new Class[count];
        Arrays.fill(spreadTypes, ((Class)aryType).getComponentType());
        return this.spread((Class<?>[])spreadTypes);
    }

    public Binder collect(int index, Class<?> type) {
        return new Binder(this, new Collect(this.type(), index, type));
    }

    public Binder collect(int index, int count, Class<?> type) {
        return new Binder(this, new Collect(this.type(), index, count, type));
    }

    public Binder varargs(int index, Class<?> type) {
        return new Binder(this, new Varargs(this.type(), index, type));
    }

    public Binder permute(int ... reorder) {
        return new Binder(this, new Permute(this.type(), reorder));
    }

    public Binder fold(MethodHandle function) {
        return new Binder(this, new Fold(function));
    }

    public Binder foldVoid(MethodHandle function) {
        if (this.type().returnType() == Void.TYPE) {
            return this.fold(function);
        }
        return this.fold(function.asType(function.type().changeReturnType(Void.TYPE)));
    }

    public Binder foldStatic(MethodHandles.Lookup lookup, Class<?> target, String method) {
        return this.fold(Binder.from(this.type()).invokeStaticQuiet(lookup, target, method));
    }

    public Binder foldStatic(Class<?> target, String method) {
        return this.foldStatic(this.lookup, target, method);
    }

    public Binder foldVirtual(MethodHandles.Lookup lookup, String method) {
        return this.fold(Binder.from(this.type()).invokeVirtualQuiet(lookup, method));
    }

    public Binder foldVirtual(String method) {
        return this.foldVirtual(this.lookup, method);
    }

    public Binder filter(int index, MethodHandle ... functions) {
        return new Binder(this, new Filter(index, functions));
    }

    public Binder filterReturn(MethodHandle function) {
        return new Binder(this, new FilterReturn(function));
    }

    public Binder tryFinally(MethodHandle post) {
        return new Binder(this, new TryFinally(post));
    }

    public Binder catchException(Class<? extends Throwable> throwable, MethodHandle function) {
        return new Binder(this, new Catch(throwable, function));
    }

    public MethodHandle nop() {
        if (this.type().returnType() != Void.TYPE) {
            throw new InvalidTransformException("must have void return type to nop: " + this.type());
        }
        return this.invoke(Binder.from(this.type()).drop(0, this.type().parameterCount()).cast(Object.class, new Class[0]).constant(null));
    }

    public MethodHandle throwException() {
        if (this.type().parameterCount() != 1 || !Throwable.class.isAssignableFrom((Class<?>)this.type().parameterType(0))) {
            throw new InvalidTransformException("incoming signature must have one Throwable type as its sole argument: " + this.type());
        }
        return this.invoke(MethodHandles.throwException(this.type().returnType(), ((Class)this.type().parameterType(0)).asSubclass(Throwable.class)));
    }

    public MethodHandle constant(Object value) {
        return this.invoke(MethodHandles.constant(this.type().returnType(), value));
    }

    public MethodHandle identity() {
        return this.invoke(MethodHandles.identity(this.type().parameterType(0)));
    }

    public MethodHandle invoke(MethodHandle target) {
        MethodHandle current = target;
        for (Transform t : this.transforms) {
            current = t.up(current);
        }
        current = MethodHandles.explicitCastArguments(current, this.start);
        return current;
    }

    public MethodHandle invoke(MethodHandles.Lookup lookup, Method method) throws IllegalAccessException {
        return this.invoke(lookup.unreflect(method));
    }

    public MethodHandle invokeQuiet(MethodHandles.Lookup lookup, Method method) {
        try {
            return this.invoke(lookup, method);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
    }

    public MethodHandle invokeStatic(MethodHandles.Lookup lookup, Class<?> target, String name) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findStatic(target, name, this.type()));
    }

    public MethodHandle invokeStaticQuiet(MethodHandles.Lookup lookup, Class<?> target, String name) {
        try {
            return this.invokeStatic(lookup, target, name);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle invokeVirtual(MethodHandles.Lookup lookup, String name) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findVirtual((Class<?>)this.type().parameterType(0), name, this.type().dropParameterTypes(0, 1)));
    }

    public MethodHandle invokeVirtualQuiet(MethodHandles.Lookup lookup, String name) {
        try {
            return this.invokeVirtual(lookup, name);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle invokeSpecial(MethodHandles.Lookup lookup, String name, Class<?> caller) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findSpecial((Class<?>)this.type().parameterType(0), name, this.type().dropParameterTypes(0, 1), caller));
    }

    public MethodHandle invokeSpecialQuiet(MethodHandles.Lookup lookup, String name, Class<?> caller) {
        try {
            return this.invokeSpecial(lookup, name, caller);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle invokeConstructor(MethodHandles.Lookup lookup, Class<?> target) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findConstructor(target, this.type().changeReturnType(Void.TYPE)));
    }

    public MethodHandle invokeConstructorQuiet(MethodHandles.Lookup lookup, Class<?> target) {
        try {
            return this.invokeConstructor(lookup, target);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle getField(MethodHandles.Lookup lookup, String name) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findGetter((Class<?>)this.type().parameterType(0), name, (Class<?>)this.type().returnType()));
    }

    public MethodHandle getFieldQuiet(MethodHandles.Lookup lookup, String name) {
        try {
            return this.getField(lookup, name);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle getStatic(MethodHandles.Lookup lookup, Class<?> target, String name) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findStaticGetter(target, name, (Class<?>)this.type().returnType()));
    }

    public MethodHandle getStaticQuiet(MethodHandles.Lookup lookup, Class<?> target, String name) {
        try {
            return this.getStatic(lookup, target, name);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle setField(MethodHandles.Lookup lookup, String name) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findSetter((Class<?>)this.type().parameterType(0), name, (Class<?>)this.type().parameterType(1)));
    }

    public MethodHandle setFieldQuiet(MethodHandles.Lookup lookup, String name) {
        try {
            return this.setField(lookup, name);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle setStatic(MethodHandles.Lookup lookup, Class<?> target, String name) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findStaticSetter(target, name, (Class<?>)this.type().parameterType(0)));
    }

    public MethodHandle setStaticQuiet(MethodHandles.Lookup lookup, Class<?> target, String name) {
        try {
            return this.setStatic(lookup, target, name);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new InvalidTransformException(e);
        }
    }

    public MethodHandle arraySet() {
        return this.invoke(MethodHandles.arrayElementSetter(this.type().parameterType(0)));
    }

    public MethodHandle arrayGet() {
        return this.invoke(MethodHandles.arrayElementGetter(this.type().parameterType(0)));
    }

    public MethodHandle branch(MethodHandle test, MethodHandle truePath, MethodHandle falsePath) {
        return this.invoke(MethodHandles.guardWithTest(test, truePath, falsePath));
    }

    public MethodHandle invoker() {
        return this.invoke(MethodHandles.invoker(this.start));
    }
}

