/*
 * Decompiled with CFR 0.152.
 */
package com.headius.backport9.stack;

import com.headius.backport9.platform.Detect;
import com.headius.backport9.stack.impl.StackWalker8;
import com.headius.backport9.stack.impl.StackWalker9;
import java.util.function.Function;
import java.util.stream.Stream;

public interface StackWalker {
    public static StackWalker getInstance() {
        if (Detect.JAVA_NINE) {
            return StackWalker.getInstance9();
        }
        return StackWalker.getInstance8();
    }

    public static StackWalker getInstance8() {
        return new StackWalker8();
    }

    public static StackWalker getInstance9() {
        return new StackWalker9();
    }

    public <T> T walk(Function<? super Stream<StackFrame>, ? extends T> var1);

    default public <T> T walk(StackTraceElement[] trace, Function<? super Stream<StackFrame>, ? extends T> function) {
        return StackWalker8.walkElements(trace, 0, trace.length, function);
    }

    public static interface StackFrame {
        public String getClassName();

        public String getMethodName();

        public Class<?> getDeclaringClass();

        public int getByteCodeIndex();

        public String getFileName();

        public int getLineNumber();

        public boolean isNativeMethod();

        public StackTraceElement toStackTraceElement();
    }
}

