/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.oauth.v2.OAuthConstants;
import org.jclouds.oauth.v2.domain.OAuthCredentials;

public class SignOrProduceMacForToken
implements Function<byte[], byte[]> {
    private final Supplier<OAuthCredentials> credentials;
    private final String signatureOrMacAlgorithm;
    private Function<byte[], byte[]> signatureOrMacFunction;

    @Inject
    public SignOrProduceMacForToken(@Named(value="jclouds.oauth.signature-or-mac-algorithm") String signatureOrMacAlgorithm, Supplier<OAuthCredentials> credentials) {
        Preconditions.checkState((boolean)OAuthConstants.OAUTH_ALGORITHM_NAMES_TO_SIGNATURE_ALGORITHM_NAMES.containsKey(signatureOrMacAlgorithm), (Object)String.format("the signature algorithm %s is not supported", signatureOrMacAlgorithm));
        this.signatureOrMacAlgorithm = OAuthConstants.OAUTH_ALGORITHM_NAMES_TO_SIGNATURE_ALGORITHM_NAMES.get(signatureOrMacAlgorithm);
        this.credentials = credentials;
    }

    @PostConstruct
    public void loadSignatureOrMacOrNone() throws InvalidKeyException, NoSuchAlgorithmException {
        this.signatureOrMacFunction = this.signatureOrMacAlgorithm.equals("none") ? new Function<byte[], byte[]>(){

            public byte[] apply(byte[] input) {
                return null;
            }
        } : (this.signatureOrMacAlgorithm.startsWith("SHA") ? new SignatureGenerator(this.signatureOrMacAlgorithm, ((OAuthCredentials)((Object)this.credentials.get())).privateKey) : new MessageAuthenticationCodeGenerator(this.signatureOrMacAlgorithm, ((OAuthCredentials)((Object)this.credentials.get())).privateKey));
    }

    public byte[] apply(byte[] input) {
        return (byte[])this.signatureOrMacFunction.apply((Object)input);
    }

    private static class SignatureGenerator
    implements Function<byte[], byte[]> {
        private Signature signature;

        private SignatureGenerator(String signatureAlgorithm, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
            this.signature = Signature.getInstance(signatureAlgorithm);
            this.signature.initSign(privateKey);
        }

        public byte[] apply(byte[] input) {
            try {
                this.signature.update(input);
                return this.signature.sign();
            }
            catch (SignatureException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static class MessageAuthenticationCodeGenerator
    implements Function<byte[], byte[]> {
        private Mac mac;

        private MessageAuthenticationCodeGenerator(String macAlgorithm, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
            this.mac = Mac.getInstance(macAlgorithm);
            this.mac.init(privateKey);
        }

        public byte[] apply(byte[] input) {
            this.mac.update(input);
            return this.mac.doFinal();
        }
    }
}

