/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.filters;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.domain.TokenRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Singleton
public class OAuthAuthenticator
implements HttpRequestFilter {
    private Function<GeneratedHttpRequest, TokenRequest> tokenRequestBuilder;
    private Function<TokenRequest, Token> tokenFetcher;

    @Inject
    OAuthAuthenticator(Function<GeneratedHttpRequest, TokenRequest> tokenRequestBuilder, LoadingCache<TokenRequest, Token> tokenFetcher) {
        this.tokenRequestBuilder = tokenRequestBuilder;
        this.tokenFetcher = tokenFetcher;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Preconditions.checkState((boolean)(request instanceof GeneratedHttpRequest), (Object)"request must be an instance of GeneratedHttpRequest");
        GeneratedHttpRequest generatedHttpRequest = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        TokenRequest tokenRequest = (TokenRequest)this.tokenRequestBuilder.apply((Object)generatedHttpRequest);
        Token token = (Token)this.tokenFetcher.apply((Object)tokenRequest);
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", new String[]{String.format("%s %s", token.getTokenType(), token.getAccessToken())})).build();
    }
}

