/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Token {
    private final String accessToken;
    private final String tokenType;
    private final long expiresIn;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Token.builder().fromToken(this);
    }

    @ConstructorProperties(value={"access_token", "token_type", "expires_in"})
    protected Token(String accessToken, String tokenType, long expiresIn) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        return Objects.equal((Object)this.accessToken, (Object)other.accessToken) && Objects.equal((Object)this.tokenType, (Object)other.tokenType) && Objects.equal((Object)this.expiresIn, (Object)other.expiresIn);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accessToken, this.tokenType, this.expiresIn});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("accessToken", (Object)this.accessToken).add("tokenType", (Object)this.tokenType).add("expiresIn", this.expiresIn);
    }

    public static class Builder {
        private String accessToken;
        private String tokenType;
        private long expiresIn;

        public Builder accessToken(String accessToken) {
            this.accessToken = (String)Preconditions.checkNotNull((Object)accessToken);
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = (String)Preconditions.checkNotNull((Object)tokenType);
            return this;
        }

        public Builder expiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Token build() {
            return new Token(this.accessToken, this.tokenType, this.expiresIn);
        }

        public Builder fromToken(Token token) {
            return new Builder().accessToken(token.accessToken).tokenType(token.tokenType).expiresIn(token.expiresIn);
        }
    }
}

