/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.security.PrivateKey;
import org.jclouds.domain.Credentials;

public class OAuthCredentials
extends Credentials {
    public final PrivateKey privateKey;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return OAuthCredentials.builder().fromOauthCredentials(this);
    }

    public OAuthCredentials(String identity, String credential, PrivateKey privateKey) {
        super(identity, credential);
        this.privateKey = privateKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OAuthCredentials other = (OAuthCredentials)((Object)obj);
        return Objects.equal((Object)this.identity, (Object)other.identity) && Objects.equal((Object)this.credential, (Object)other.credential) && Objects.equal((Object)this.privateKey, (Object)other.privateKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.identity, this.credential, this.privateKey});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("identity", (Object)this.identity).add("credential", this.credential != null ? Integer.valueOf(this.credential.hashCode()) : null).add("privateKey", this.privateKey.hashCode());
    }

    public static class Builder
    extends Credentials.Builder<OAuthCredentials> {
        protected PrivateKey privateKey;

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)privateKey);
            return this;
        }

        public Builder identity(String identity) {
            this.identity = (String)Preconditions.checkNotNull((Object)identity);
            return this;
        }

        public Builder credential(String credential) {
            this.credential = credential;
            return this;
        }

        public OAuthCredentials build() {
            return new OAuthCredentials((String)Preconditions.checkNotNull((Object)this.identity), this.credential, this.privateKey);
        }

        public Builder fromOauthCredentials(OAuthCredentials credentials) {
            return new Builder().privateKey(credentials.privateKey).identity(credentials.identity).credential(credentials.credential);
        }
    }
}

