/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.PayloadEnclosing;

@Singleton
public class AWSServerErrorRetryHandler
extends BackoffLimitedRetryHandler {
    private final AWSUtils utils;
    private final Set<String> retryableServerCodes;

    @Inject
    public AWSServerErrorRetryHandler(AWSUtils utils, @ServerError Set<String> retryableServerCodes) {
        this.utils = utils;
        this.retryableServerCodes = retryableServerCodes;
    }

    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        switch (response.getStatusCode()) {
            case 503: {
                if (response.getPayload() == null) break;
                HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
                AWSError error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
                if (error == null) break;
                return this.shouldRetryRequestOnError(command, response, error);
            }
            case 504: {
                return super.shouldRetryRequest(command, response);
            }
        }
        return false;
    }

    protected boolean shouldRetryRequestOnError(HttpCommand command, HttpResponse response, AWSError error) {
        if (this.retryableServerCodes.contains(error.getCode())) {
            return super.shouldRetryRequest(command, response);
        }
        return false;
    }

    public void imposeBackoffExponentialDelay(long period, int pow, int failureCount, int max, String commandDescription) {
        this.imposeBackoffExponentialDelay(period, period * 100L, pow, failureCount, max, commandDescription);
    }
}

