/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindTableToIndexedFormParams
implements Binder {
    private final String rowPattern;
    private final String columnPattern;
    private final String valuePattern;

    protected BindTableToIndexedFormParams(String rowPattern, String columnPattern, String valuePattern) {
        this.rowPattern = rowPattern;
        this.columnPattern = columnPattern;
        this.valuePattern = valuePattern;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map) {
            ImmutableTable.Builder builder = ImmutableTable.builder();
            int index = 1;
            for (Map.Entry entry : ((Map)input).entrySet()) {
                builder.put((Object)index++, entry.getKey(), entry.getValue());
            }
            input = builder.build();
        }
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Table), (Object)"this binder is only valid for Table");
        Table table = (Table)Table.class.cast(input);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int amazonOneBasedIndex = 1;
        for (Table.Cell cell : table.cellSet()) {
            builder.put((Object)String.format(this.rowPattern, amazonOneBasedIndex), (Object)cell.getRowKey().toString());
            builder.put((Object)String.format(this.columnPattern, amazonOneBasedIndex), (Object)cell.getColumnKey().toString());
            builder.put((Object)String.format(this.valuePattern, amazonOneBasedIndex), (Object)cell.getValue().toString());
            ++amazonOneBasedIndex;
        }
        SetMultimap forms = Multimaps.forMap((Map)builder.build());
        return (R)(forms.size() == 0 ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }
}

