/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.worker;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.worker.TestContainer;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WorkerMessageProcessor {
    private static final ILogger log = Logger.getLogger(WorkerMessageProcessor.class);
    private static final int TIMEOUT = 60;
    private final ConcurrentMap<String, TestContainer<TestContext>> tests;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(10);
    private Random random = new Random();
    private HazelcastInstance hazelcastServerInstance;
    private HazelcastInstance hazelcastClientInstance;

    public WorkerMessageProcessor(ConcurrentMap<String, TestContainer<TestContext>> tests) {
        this.tests = tests;
    }

    public void setHazelcastServerInstance(HazelcastInstance hazelcastServerInstance) {
        this.hazelcastServerInstance = hazelcastServerInstance;
    }

    public void setHazelcastClientInstance(HazelcastInstance hazelcastClientInstance) {
        this.hazelcastClientInstance = hazelcastClientInstance;
    }

    public void submit(final Message message) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (WorkerMessageProcessor.this.shouldProcess(message)) {
                    WorkerMessageProcessor.this.process(message);
                }
            }
        });
    }

    private void process(Message message) {
        this.injectHazecastInstance(message);
        if (message.getMessageAddress().getTestAddress() == null) {
            this.processLocalMessage(message);
        } else {
            try {
                this.processTestMessage(message);
            }
            catch (Throwable throwable) {
                log.severe("Error while processing message", throwable);
            }
        }
    }

    private boolean shouldProcess(Message message) {
        String workerAddress = message.getMessageAddress().getWorkerAddress();
        if (workerAddress.equals("O")) {
            return this.isMaster();
        }
        return true;
    }

    private boolean isMaster() {
        if (this.hazelcastServerInstance == null || !this.isOldestMember()) {
            return false;
        }
        try {
            return (Boolean)this.executor.schedule(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return WorkerMessageProcessor.this.isOldestMember();
                }
            }, 10L, TimeUnit.SECONDS).get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isOldestMember() {
        Iterator memberIterator = this.hazelcastServerInstance.getCluster().getMembers().iterator();
        boolean master = memberIterator.hasNext() && ((Member)memberIterator.next()).equals(this.hazelcastServerInstance.getLocalEndpoint());
        return master;
    }

    private void injectHazecastInstance(Message message) {
        if (message instanceof HazelcastInstanceAware) {
            if (this.hazelcastServerInstance != null) {
                ((HazelcastInstanceAware)message).setHazelcastInstance(this.hazelcastServerInstance);
            } else if (this.hazelcastClientInstance != null) {
                ((HazelcastInstanceAware)message).setHazelcastInstance(this.hazelcastClientInstance);
            } else {
                log.warning("Message " + message.getClass().getName() + " implements " + HazelcastInstanceAware.class + " interface, but no instance is currently running in this worker.");
            }
        }
    }

    private void processTestMessage(Message message) throws Throwable {
        String testAddress = message.getMessageAddress().getTestAddress();
        if ("*".equals(testAddress)) {
            for (TestContainer testContainer : this.tests.values()) {
                testContainer.sendMessage(message);
            }
        } else if ("R".equals(testAddress)) {
            TestContainer<?> randomTestContainer = this.getRandomTestContainerOrNull();
            if (randomTestContainer == null) {
                log.warning("No test container is known to this worker. Is it a race-condition?");
            } else {
                randomTestContainer.sendMessage(message);
            }
        }
    }

    private void processLocalMessage(Message message) {
        if (!(message instanceof Runnable)) {
            throw new UnsupportedOperationException("Non-runnable messages to workers are not implemented yet");
        }
        this.processLocalRunnableMessage((Runnable)((Object)message));
    }

    private void processLocalRunnableMessage(Runnable message) {
        log.info("Processing local runnable message: " + message.getClass().getName());
        Runnable executable = message;
        executable.run();
    }

    public TestContainer<?> getRandomTestContainerOrNull() {
        TestContainer[] testContainers = this.tests.values().toArray(new TestContainer[0]);
        if (testContainers.length == 0) {
            return null;
        }
        TestContainer randomTestContainer = testContainers[this.random.nextInt(testContainers.length)];
        return randomTestContainer;
    }
}

