/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.worker;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.TestCase;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.utils.ExceptionReporter;
import com.hazelcast.stabilizer.tests.utils.TestUtils;
import com.hazelcast.stabilizer.worker.TerminateWorkerException;
import com.hazelcast.stabilizer.worker.TestContainer;
import com.hazelcast.stabilizer.worker.WorkerMessageProcessor;
import com.hazelcast.stabilizer.worker.commands.Command;
import com.hazelcast.stabilizer.worker.commands.CommandRequest;
import com.hazelcast.stabilizer.worker.commands.CommandResponse;
import com.hazelcast.stabilizer.worker.commands.DoneCommand;
import com.hazelcast.stabilizer.worker.commands.GenericCommand;
import com.hazelcast.stabilizer.worker.commands.GetOperationCountCommand;
import com.hazelcast.stabilizer.worker.commands.InitCommand;
import com.hazelcast.stabilizer.worker.commands.MessageCommand;
import com.hazelcast.stabilizer.worker.commands.RunCommand;
import com.hazelcast.stabilizer.worker.commands.StopCommand;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Worker {
    static final ILogger log = Logger.getLogger(Worker.class);
    private HazelcastInstance serverInstance;
    private HazelcastInstance clientInstance;
    private String hzFile;
    private String clientHzFile;
    private String workerMode;
    private String workerId;
    private final ConcurrentMap<String, TestContainer<TestContext>> tests = new ConcurrentHashMap<String, TestContainer<TestContext>>();
    private final ConcurrentMap<String, Command> commands = new ConcurrentHashMap<String, Command>();
    private WorkerMessageProcessor workerMessageProcessor = new WorkerMessageProcessor(this.tests);
    private final BlockingQueue<CommandRequest> requestQueue = new LinkedBlockingQueue<CommandRequest>();
    private final BlockingQueue<CommandResponse> responseQueue = new LinkedBlockingQueue<CommandResponse>();

    public void start() throws Exception {
        if ("server".equals(this.workerMode)) {
            this.serverInstance = this.createServerHazelcastInstance();
        } else if ("client".equals(this.workerMode)) {
            this.clientInstance = this.createClientHazelcastInstance();
        } else if ("mixed".equals(this.workerMode)) {
            this.serverInstance = this.createServerHazelcastInstance();
            this.clientInstance = this.createClientHazelcastInstance();
        } else {
            throw new IllegalStateException("Unknown worker mode:" + this.workerMode);
        }
        this.workerMessageProcessor.setHazelcastServerInstance(this.serverInstance);
        this.workerMessageProcessor.setHazelcastClientInstance(this.clientInstance);
        new TestCommandRequestProcessingThread().start();
        new SocketThread().start();
        this.signalStartToAgent();
    }

    private void signalStartToAgent() {
        String address;
        if (this.serverInstance == null) {
            address = "client:" + Utils.getHostAddress();
        } else {
            InetSocketAddress socketAddress = this.serverInstance.getCluster().getLocalMember().getInetSocketAddress();
            address = socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
        }
        File file = new File("worker.address");
        Utils.writeObject(address, file);
    }

    private HazelcastInstance createClientHazelcastInstance() throws Exception {
        log.info("Creating Client HazelcastInstance");
        XmlClientConfigBuilder configBuilder = new XmlClientConfigBuilder(this.clientHzFile);
        ClientConfig clientConfig = configBuilder.build();
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        log.info("Successfully created Client HazelcastInstance");
        return client;
    }

    private HazelcastInstance createServerHazelcastInstance() throws Exception {
        log.info("Creating Server HazelcastInstance");
        XmlConfigBuilder configBuilder = new XmlConfigBuilder(this.hzFile);
        Config config = configBuilder.build();
        HazelcastInstance server = Hazelcast.newHazelcastInstance((Config)config);
        log.info("Successfully created Server HazelcastInstance");
        return server;
    }

    private static void logInterestingSystemProperties() {
        Worker.logSystemProperty("java.class.path");
        Worker.logSystemProperty("java.home");
        Worker.logSystemProperty("java.vendor");
        Worker.logSystemProperty("java.vendor.url");
        Worker.logSystemProperty("sun.java.command");
        Worker.logSystemProperty("java.version");
        Worker.logSystemProperty("os.arch");
        Worker.logSystemProperty("os.name");
        Worker.logSystemProperty("os.version");
        Worker.logSystemProperty("user.dir");
        Worker.logSystemProperty("user.home");
        Worker.logSystemProperty("user.name");
        Worker.logSystemProperty("STABILIZER_HOME");
        Worker.logSystemProperty("hazelcast.logging.type");
        Worker.logSystemProperty("log4j.configuration");
    }

    private static void logSystemProperty(String name) {
        log.info(String.format("%s=%s", name, System.getProperty(name)));
    }

    public static void main(String[] args) {
        log.info("Starting Stabilizer Worker");
        try {
            Worker.logInputArguments();
            Worker.logInterestingSystemProperties();
            String workerId = System.getProperty("workerId");
            log.info("Worker id:" + workerId);
            String workerHzFile = args[0];
            log.info("Worker hz config file:" + workerHzFile);
            log.info(Utils.fileAsText(new File(workerHzFile)));
            String clientHzFile = args[1];
            log.info("Client hz config file:" + clientHzFile);
            log.info(Utils.fileAsText(new File(clientHzFile)));
            String workerMode = System.getProperty("workerMode");
            log.info("Worker mode:" + workerMode);
            Worker worker = new Worker();
            worker.workerId = workerId;
            worker.hzFile = workerHzFile;
            worker.clientHzFile = clientHzFile;
            worker.workerMode = workerMode;
            worker.start();
            log.info("Successfully started Hazelcast Stabilizer Worker:" + workerId);
        }
        catch (Throwable e) {
            ExceptionReporter.report(null, e);
            System.exit(1);
        }
    }

    private static void logInputArguments() {
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        log.info("jvm input arguments = " + inputArguments);
    }

    class TestContextImpl
    implements TestContext {
        private final String testId;
        volatile boolean stopped = false;

        TestContextImpl(String testId) {
            this.testId = testId;
        }

        @Override
        public HazelcastInstance getTargetInstance() {
            if (Worker.this.clientInstance != null) {
                return Worker.this.clientInstance;
            }
            return Worker.this.serverInstance;
        }

        @Override
        public String getTestId() {
            return this.testId;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void stop() {
            this.stopped = true;
        }
    }

    abstract class CommandThread
    extends Thread {
        private final Command command;
        private final String testId;

        public CommandThread(Command command, String testId) {
            this.command = command;
            this.testId = testId;
        }

        public abstract void doRun() throws Throwable;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                Worker.this.commands.put(this.testId, this.command);
                this.doRun();
            }
            catch (Throwable t) {
                ExceptionReporter.report(null, t);
            }
            finally {
                Worker.this.commands.remove(this.testId);
            }
        }
    }

    private class TestCommandRequestProcessingThread
    extends Thread {
        private TestCommandRequestProcessingThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CommandRequest request;
                        if ((request = (CommandRequest)Worker.this.requestQueue.take()) == null) {
                            throw new NullPointerException("request can't be null");
                        }
                        this.doProcess(request.id, request.task);
                    }
                }
                catch (Throwable e) {
                    ExceptionReporter.report(null, e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doProcess(long id, Command command) throws Throwable {
            block17: {
                Comparable<Boolean> result = null;
                try {
                    if (command instanceof DoneCommand) {
                        result = this.process((DoneCommand)command);
                    } else if (command instanceof InitCommand) {
                        this.process((InitCommand)command);
                    } else if (command instanceof RunCommand) {
                        this.process((RunCommand)command);
                    } else if (command instanceof StopCommand) {
                        this.process((StopCommand)command);
                    } else if (command instanceof GenericCommand) {
                        this.process((GenericCommand)command);
                    } else if (command instanceof GetOperationCountCommand) {
                        result = this.process((GetOperationCountCommand)command);
                    } else if (command instanceof MessageCommand) {
                        this.process((MessageCommand)command);
                    } else {
                        throw new RuntimeException("Unhandled task:" + command.getClass());
                    }
                    if (!command.awaitReply()) break block17;
                    CommandResponse response = new CommandResponse();
                    response.commandId = id;
                    response.result = result;
                    Worker.this.responseQueue.add(response);
                }
                catch (Throwable throwable) {
                    if (command.awaitReply()) {
                        CommandResponse response = new CommandResponse();
                        response.commandId = id;
                        response.result = result;
                        Worker.this.responseQueue.add(response);
                    }
                    throw throwable;
                }
            }
        }

        private void process(MessageCommand command) {
            Message message = command.getMessage();
            Worker.this.workerMessageProcessor.submit(message);
        }

        private Long process(GetOperationCountCommand command) throws Throwable {
            long result = 0L;
            for (TestContainer testContainer : Worker.this.tests.values()) {
                result += testContainer.getOperationCount();
            }
            return result;
        }

        private void process(final RunCommand command) throws Exception {
            try {
                log.info("Starting test");
                final TestContainer test = (TestContainer)Worker.this.tests.get(command.testId);
                if (test == null) {
                    log.warning("Failed to process command: " + command + " no test with " + "testId" + command.testId + " is found");
                    return;
                }
                new CommandThread(command, command.testId){

                    @Override
                    public void doRun() throws Throwable {
                        boolean passive;
                        boolean bl = passive = command.clientOnly && Worker.this.clientInstance == null;
                        if (!passive) {
                            test.run();
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                log.severe("Failed to start test", (Throwable)e);
                throw e;
            }
        }

        public void process(GenericCommand command) throws Throwable {
            final String methodName = command.methodName;
            final String testId = command.testId;
            final String testName = "".equals(testId) ? "test" : testId;
            try {
                log.info(String.format("Calling %s.%s()", testName, methodName));
                final TestContainer test = (TestContainer)Worker.this.tests.get(testId);
                if (test == null) {
                    log.warning("Failed to process command: " + command + " no test with " + "testId " + testId + " is found");
                    return;
                }
                final Method method = test.getClass().getMethod(methodName, new Class[0]);
                new CommandThread(command, command.testId){

                    @Override
                    public void doRun() throws Throwable {
                        try {
                            method.invoke((Object)test, new Object[0]);
                            log.info(String.format("Finished %s.%s()", testName, methodName));
                        }
                        catch (InvocationTargetException e) {
                            log.severe(String.format("Failed %s.%s()", testName, methodName));
                            throw e.getCause();
                        }
                        finally {
                            if ("localTeardown".equals(methodName)) {
                                Worker.this.tests.remove(testId);
                            }
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                log.severe(String.format("Failed to execute test.%s()", methodName), (Throwable)e);
                throw e;
            }
        }

        private void process(InitCommand command) throws Throwable {
            try {
                TestCase testCase = command.testCase;
                log.info("Init Test:\n" + testCase);
                if (Worker.this.tests.containsKey(testCase.getId())) {
                    throw new IllegalStateException("Can't init testcase: " + command + ", another test with [" + testCase.id + "] testId already exists");
                }
                String clazzName = testCase.getClassname();
                Object testObject = InitCommand.class.getClassLoader().loadClass(clazzName).newInstance();
                TestUtils.bindProperties(testObject, testCase);
                TestContextImpl testContext = new TestContextImpl(testCase.id);
                TestContainer<TestContextImpl> testContainer = new TestContainer<TestContextImpl>(testObject, testContext);
                Worker.this.tests.put(testContext.getTestId(), testContainer);
                if (Worker.this.serverInstance != null) {
                    Worker.this.serverInstance.getUserContext().put("testInstance:" + testCase.id, testObject);
                }
            }
            catch (Throwable e) {
                log.severe("Failed to init Test", e);
                throw e;
            }
        }

        public void process(StopCommand command) throws Exception {
            try {
                log.info("Calling test.stop");
                TestContainer test = (TestContainer)Worker.this.tests.get(command.testId);
                if (test == null) {
                    log.warning("Can't stop test, test with id " + command.testId + " does not exist");
                    return;
                }
                test.getTestContext().stop();
                log.info("Finished calling test.stop()");
            }
            catch (Exception e) {
                log.severe("Failed to execute test.stop", (Throwable)e);
                throw e;
            }
        }

        public boolean process(DoneCommand command) throws Exception {
            return !Worker.this.commands.containsKey(command.testId);
        }
    }

    private class SocketThread
    extends Thread {
        private SocketThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        List requests = (List)this.execute("poll", Worker.this.workerId);
                        for (CommandRequest request : requests) {
                            Worker.this.requestQueue.add(request);
                        }
                        CommandResponse response = (CommandResponse)Worker.this.responseQueue.poll(1L, TimeUnit.SECONDS);
                        if (response == null) continue;
                        this.sendResponse(Arrays.asList(response));
                        LinkedList<CommandResponse> responses = new LinkedList<CommandResponse>();
                        Worker.this.responseQueue.drainTo(responses);
                        this.sendResponse(responses);
                    }
                }
                catch (Throwable e) {
                    ExceptionReporter.report(null, e);
                    continue;
                }
                break;
            }
        }

        private void sendResponse(List<CommandResponse> responses) throws Exception {
            for (CommandResponse response : responses) {
                this.execute("push", Worker.this.workerId, response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <E> E execute(String service, Object ... args) throws Exception {
            Socket socket = new Socket(InetAddress.getByName(null), 9001);
            try {
                ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
                oos.writeObject(service);
                for (Object arg : args) {
                    oos.writeObject(arg);
                }
                oos.flush();
                ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
                Object response = in.readObject();
                if (response instanceof TerminateWorkerException) {
                    System.exit(0);
                }
                if (response instanceof Exception) {
                    Exception exception = (Exception)response;
                    Utils.fixRemoteStackTrace(exception, Thread.currentThread().getStackTrace());
                    throw exception;
                }
                Object object = response;
                return (E)object;
            }
            finally {
                Utils.closeQuietly(socket);
            }
        }
    }
}

