/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.worker;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.common.messaging.Message;
import com.hazelcast.stabilizer.tests.IllegalTestException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Receive;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

public class TestContainer<T extends TestContext> {
    private static final ILogger log = Logger.getLogger(TestContainer.class);
    private final Object testObject;
    private final Class<? extends Object> clazz;
    private final T testContext;
    private Method runMethod;
    private Method setupMethod;
    private Method localTeardownMethod;
    private Method globalTeardownMethod;
    private Method localWarmupMethod;
    private Method globalWarmupMethod;
    private Method localVerifyMethod;
    private Method globalVerifyMethod;
    private Method operationCountMethod;
    private Method messageConsumerMethod;

    public TestContainer(Object testObject, T testContext) {
        if (testObject == null) {
            throw new NullPointerException();
        }
        if (testContext == null) {
            throw new NullPointerException();
        }
        this.testContext = testContext;
        this.testObject = testObject;
        this.clazz = testObject.getClass();
        this.initMethods();
    }

    private void initMethods() {
        this.initRunMethod();
        this.initSetupMethod();
        this.initLocalTeardownMethod();
        this.initGlobalTeardownMethod();
        this.initLocalWarmupMethod();
        this.initGlobalWarmupMethod();
        this.initLocalVerifyMethod();
        this.initGlobalVerifyMethod();
        this.initGetOperationCountMethod();
        this.initMessageConsumerMethod();
    }

    public T getTestContext() {
        return this.testContext;
    }

    public long getOperationCount() throws Throwable {
        Long count = (Long)this.invoke(this.operationCountMethod, new Object[0]);
        return count == null ? -1L : count;
    }

    public void run() throws Throwable {
        this.invoke(this.runMethod, new Object[0]);
    }

    public void setup() throws Throwable {
        this.invoke(this.setupMethod, this.testContext);
    }

    public void globalTeardown() throws Throwable {
        this.invoke(this.globalTeardownMethod, new Object[0]);
    }

    public void localTeardown() throws Throwable {
        this.invoke(this.localTeardownMethod, new Object[0]);
    }

    public void localVerify() throws Throwable {
        this.invoke(this.localVerifyMethod, new Object[0]);
    }

    public void globalVerify() throws Throwable {
        this.invoke(this.globalVerifyMethod, new Object[0]);
    }

    public void localWarmup() throws Throwable {
        this.invoke(this.localWarmupMethod, new Object[0]);
    }

    public void globalWarmup() throws Throwable {
        this.invoke(this.globalWarmupMethod, new Object[0]);
    }

    public void sendMessage(Message message) throws Throwable {
        this.invoke(this.messageConsumerMethod, message);
    }

    private <E> E invoke(Method method, Object ... args) throws Throwable {
        if (method == null) {
            return null;
        }
        try {
            return (E)method.invoke(this.testObject, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void initSetupMethod() {
        List<Method> methods = this.findMethod(Setup.class);
        this.assertAtMostOne(methods, Setup.class);
        if (methods.isEmpty()) {
            return;
        }
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertNotStatic(method);
        this.assertVoidReturnType(method);
        this.assertTestContextArgument(method);
        this.setupMethod = method;
    }

    private void initGetOperationCountMethod() {
        List<Method> methods = this.findMethod(Performance.class);
        this.assertAtMostOne(methods, Performance.class);
        if (methods.isEmpty()) {
            return;
        }
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.assertReturnType(method, Long.TYPE);
        this.operationCountMethod = method;
    }

    private void initRunMethod() {
        List<Method> methods = this.findMethod(Run.class);
        this.assertExactlyOne(methods, Run.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.runMethod = method;
    }

    private void initLocalVerifyMethod() {
        List<Method> methods = this.findMethod(Verify.class, new Filter<Verify>(){

            @Override
            public boolean allowed(Verify t) {
                return !t.global();
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Verify.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.localVerifyMethod = method;
    }

    private void initGlobalVerifyMethod() {
        List<Method> methods = this.findMethod(Verify.class, new Filter<Verify>(){

            @Override
            public boolean allowed(Verify t) {
                return t.global();
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Verify.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.globalVerifyMethod = method;
    }

    private void initLocalTeardownMethod() {
        List<Method> methods = this.findMethod(Teardown.class, new Filter<Teardown>(){

            @Override
            public boolean allowed(Teardown t) {
                return !t.global();
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Teardown.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.localTeardownMethod = method;
    }

    private void initGlobalTeardownMethod() {
        List<Method> methods = this.findMethod(Teardown.class, new Filter<Teardown>(){

            @Override
            public boolean allowed(Teardown t) {
                return t.global();
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Teardown.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.globalTeardownMethod = method;
    }

    private void initLocalWarmupMethod() {
        List<Method> methods = this.findMethod(Warmup.class, new Filter<Warmup>(){

            @Override
            public boolean allowed(Warmup t) {
                return !t.global();
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Warmup.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.localWarmupMethod = method;
    }

    private void initGlobalWarmupMethod() {
        List<Method> methods = this.findMethod(Warmup.class, new Filter<Warmup>(){

            @Override
            public boolean allowed(Warmup t) {
                return t.global();
            }
        });
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Warmup.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertNoArgs(method);
        this.globalWarmupMethod = method;
    }

    private void initMessageConsumerMethod() {
        List<Method> methods = this.findMethod(Receive.class);
        if (methods.isEmpty()) {
            return;
        }
        this.assertAtMostOne(methods, Receive.class);
        Method method = methods.get(0);
        method.setAccessible(true);
        this.assertVoidReturnType(method);
        this.assertNotStatic(method);
        this.assertArguments(method, Message.class);
        this.messageConsumerMethod = method;
    }

    private void assertNotStatic(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalTestException(String.format("Method  %s can't be static", method.getName()));
        }
    }

    private void assertNoArgs(Method method) {
        if (method.getParameterTypes().length == 0) {
            return;
        }
        throw new IllegalTestException(String.format("Method '%s' can't have any args", method));
    }

    private void assertTestContextArgument(Method method) {
        if (method.getParameterTypes().length == 1) {
            return;
        }
        if (TestContext.class.equals(method.getParameterTypes()[0])) {
            return;
        }
        throw new IllegalTestException("Method " + this.clazz + "." + method + " should have single argument of type " + TestContext.class);
    }

    private void assertArguments(Method method, Class<?> ... arguments) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != arguments.length) {
            throw new IllegalTestException(String.format("Method %s must have %s arguments, but %s arguments found", method, arguments.length, parameterTypes.length));
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(arguments[i])) continue;
            throw new IllegalTestException(String.format("Method %s has %s. argument of type %s where type %s is expected", method, i + 1, parameterTypes[i], arguments[i]));
        }
    }

    private void assertExactlyOne(List<Method> methods, Class<? extends Annotation> annotation) {
        if (methods.size() == 0) {
            throw new IllegalTestException(String.format("No method annotated with %s found on class %s", annotation.getName(), this.clazz.getName()));
        }
        if (methods.size() == 1) {
            return;
        }
        throw new IllegalTestException(String.format("Too many methods on class %s with annotation %s", this.clazz.getName(), annotation.getName()));
    }

    private void assertAtMostOne(List<Method> methods, Class<? extends Annotation> annotation) {
        if (methods.size() > 1) {
            throw new IllegalTestException(String.format("Too many methods on class %s with annotation %s", this.clazz.getName(), annotation.getName()));
        }
    }

    private void assertVoidReturnType(Method method) {
        this.assertReturnType(method, Void.TYPE);
    }

    private void assertReturnType(Method method, Class expectedType) {
        if (expectedType.equals(method.getReturnType())) {
            return;
        }
        throw new IllegalTestException("Method " + this.clazz + "." + method + " should have returnType: " + expectedType);
    }

    private List<Method> findMethod(Class<? extends Annotation> annotation) {
        return this.findMethod(annotation, new AlwaysFilter());
    }

    private List<Method> findMethod(Class<? extends Annotation> annotation, Filter filter) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method method : this.clazz.getDeclaredMethods()) {
            Annotation found = method.getAnnotation(annotation);
            if (found == null || !filter.allowed(found)) continue;
            methods.add(method);
        }
        return methods;
    }

    private class AlwaysFilter
    implements Filter {
        private AlwaysFilter() {
        }

        public boolean allowed(Annotation m) {
            return true;
        }
    }

    private static interface Filter<A extends Annotation> {
        public boolean allowed(A var1);
    }
}

