/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.utils;

import com.hazelcast.stabilizer.tests.utils.ExceptionReporter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadSpawner {
    private final List<Thread> threads = Collections.synchronizedList(new LinkedList());
    private final ConcurrentMap<String, AtomicInteger> idMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final String testId;

    public ThreadSpawner() {
        this(null);
    }

    public ThreadSpawner(String testId) {
        this.testId = testId;
    }

    public Thread spawn(Runnable runnable) {
        return this.spawn("Thread", runnable);
    }

    public Thread spawn(String namePrefix, Runnable runnable) {
        if (namePrefix == null) {
            throw new NullPointerException("namePrefix can't be null");
        }
        if (runnable == null) {
            throw new NullPointerException("runnable can't be null");
        }
        DefaultThread t = new DefaultThread(this.getName(namePrefix), runnable);
        this.threads.add(t);
        t.start();
        return t;
    }

    private String getName(String prefix) {
        AtomicInteger idGenerator = (AtomicInteger)this.idMap.get(prefix);
        if (idGenerator == null) {
            idGenerator = new AtomicInteger();
            AtomicInteger result = this.idMap.putIfAbsent(prefix, idGenerator);
            idGenerator = result == null ? idGenerator : result;
        }
        return prefix + "-" + idGenerator.incrementAndGet();
    }

    public void awaitCompletion() {
        for (Thread t : this.threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class DefaultThread
    extends Thread {
        public DefaultThread(String name, Runnable task) {
            super(task, name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Throwable t) {
                ExceptionReporter.report(ThreadSpawner.this.testId, t);
            }
        }
    }
}

