/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.utils;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.instance.Node;
import com.hazelcast.stabilizer.TestCase;
import com.hazelcast.stabilizer.tests.BindException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class TestUtils {
    public static final String TEST_INSTANCE = "testInstance";

    public static Node getNode(HazelcastInstance hz) {
        HazelcastInstanceImpl impl = TestUtils.getHazelcastInstanceImpl(hz);
        return impl != null ? impl.node : null;
    }

    public static long secondsToMillis(int seconds) {
        return seconds * 1000;
    }

    public static HazelcastInstanceImpl getHazelcastInstanceImpl(HazelcastInstance hz) {
        HazelcastInstanceImpl impl = null;
        if (hz instanceof HazelcastInstanceProxy) {
            return (HazelcastInstanceImpl)TestUtils.getField(hz, "original");
        }
        if (hz instanceof HazelcastInstanceImpl) {
            impl = (HazelcastInstanceImpl)hz;
        }
        return impl;
    }

    public static <E> E getField(Object o, String fieldName) {
        try {
            Field field = o.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (E)field.get(o);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void bindProperties(Object test, TestCase testCase) throws NoSuchFieldException, IllegalAccessException {
        for (Map.Entry<String, String> entry : testCase.getProperties().entrySet()) {
            String property = entry.getKey();
            if ("class".equals(property)) continue;
            String value = entry.getValue();
            TestUtils.bindProperty(test, property, value);
        }
    }

    public static void bindProperty(Object test, String property, String value) throws IllegalAccessException {
        block41: {
            Field field = TestUtils.findPropertyField(test.getClass(), property);
            if (field == null) {
                throw new BindException(String.format("Property [%s.%s] does not exist", test.getClass().getName(), property));
            }
            field.setAccessible(true);
            try {
                if (Boolean.TYPE.equals(field.getType())) {
                    if ("true".equals(value)) {
                        field.set(test, true);
                        break block41;
                    }
                    if ("false".equals(value)) {
                        field.set(test, false);
                        break block41;
                    }
                    throw new NumberFormatException("Unrecognized boolean value:" + value);
                }
                if (Boolean.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                        break block41;
                    }
                    if ("true".equals(value)) {
                        field.set(test, true);
                        break block41;
                    }
                    if ("false".equals(value)) {
                        field.set(test, false);
                        break block41;
                    }
                    throw new NumberFormatException("Unrecognized boolean value:" + value);
                }
                if (Byte.TYPE.equals(field.getType())) {
                    field.set(test, Byte.parseByte(value));
                    break block41;
                }
                if (Byte.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, Byte.parseByte(value));
                    }
                    break block41;
                }
                if (Short.TYPE.equals(field.getType())) {
                    field.set(test, Short.parseShort(value));
                    break block41;
                }
                if (Short.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, Short.parseShort(value));
                    }
                    break block41;
                }
                if (Integer.TYPE.equals(field.getType())) {
                    field.set(test, Integer.parseInt(value));
                    break block41;
                }
                if (Integer.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, Integer.parseInt(value));
                    }
                    break block41;
                }
                if (Long.TYPE.equals(field.getType())) {
                    field.set(test, Long.parseLong(value));
                    break block41;
                }
                if (Long.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, Long.parseLong(value));
                    }
                    break block41;
                }
                if (Float.TYPE.equals(field.getType())) {
                    field.set(test, Float.valueOf(Float.parseFloat(value)));
                    break block41;
                }
                if (Float.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, Float.valueOf(Float.parseFloat(value)));
                    }
                    break block41;
                }
                if (Double.TYPE.equals(field.getType())) {
                    field.set(test, Double.parseDouble(value));
                    break block41;
                }
                if (Double.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, Double.parseDouble(value));
                    }
                    break block41;
                }
                if (String.class.equals(field.getType())) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                    } else {
                        field.set(test, value);
                    }
                    break block41;
                }
                if (field.getType().isEnum()) {
                    if ("null".equals(value)) {
                        field.set(test, null);
                        break block41;
                    }
                    try {
                        Object enumValue = Enum.valueOf(field.getType(), value);
                        field.set(test, enumValue);
                        break block41;
                    }
                    catch (IllegalArgumentException e) {
                        throw new NumberFormatException(e.getMessage());
                    }
                }
                throw new BindException(String.format("Unhandled type [%s] for field [%s.%s]", field.getType(), test.getClass().getName(), field.getName()));
            }
            catch (NumberFormatException e) {
                throw new BindException(String.format("Failed to bind value [%s] to property [%s.%s] of type [%s]", value, test.getClass().getName(), property, field.getType()));
            }
        }
    }

    public static Field findPropertyField(Class clazz, String property) {
        try {
            Field field = clazz.getDeclaredField(property);
            if (Modifier.isStatic(field.getModifiers())) {
                throw new BindException(String.format("Property [%s.%s] can't be static", clazz.getName(), property));
            }
            if (Modifier.isFinal(field.getModifiers())) {
                throw new BindException(String.format("Property [%s.%s] can't be final", clazz.getName(), property));
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            return TestUtils.findPropertyField(superClass, property);
        }
    }

    private TestUtils() {
    }
}

