/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.utils;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ExceptionReporter {
    private static final AtomicLong FAILURE_ID = new AtomicLong(1L);
    private static final ILogger log = Logger.getLogger(ExceptionReporter.class);

    public static void report(String testId, Throwable cause) {
        if (cause == null) {
            log.severe("Can't call report with a null exception");
            return;
        }
        log.severe("Exception detected", cause);
        File tmpFile = ExceptionReporter.createTmpFile();
        if (tmpFile == null) {
            return;
        }
        ExceptionReporter.writeCauseToFile(testId, cause, tmpFile);
        File file = new File(FAILURE_ID.incrementAndGet() + ".exception");
        if (!tmpFile.renameTo(file)) {
            log.severe("Failed to rename tmp file:" + tmpFile + " to " + file);
        }
    }

    private static void writeCauseToFile(String testId, Throwable cause, File file) {
        String text = testId + "\n" + Utils.throwableToString(cause);
        Utils.writeText(text, file);
    }

    private static File createTmpFile() {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("worker", "exception");
        }
        catch (IOException e) {
            log.severe("Failed to create temp file", (Throwable)e);
            return null;
        }
        return tmpFile;
    }

    private ExceptionReporter() {
    }
}

