/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.queue;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.helpers.TxnCounter;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import com.hazelcast.transaction.TransactionContext;
import org.junit.Assert;

public class TxnQueueWithLockTest {
    public String basename = this.getClass().getName();
    public int threadCount = 5;
    private HazelcastInstance instance = null;
    private TestContext testContext = null;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.instance = testContext.getTargetInstance();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify(global=true)
    public void verify() {
        IQueue queue = this.instance.getQueue(this.basename + "q");
        ILock firstLock = this.instance.getLock(this.basename + "l1");
        ILock secondLock = this.instance.getLock(this.basename + "l2");
        IList results = this.instance.getList(this.basename + "results");
        TxnCounter total = new TxnCounter();
        for (TxnCounter counter : results) {
            total.add(counter);
        }
        System.out.println(this.basename + ": " + total + " from " + results.size());
        Assert.assertFalse((boolean)firstLock.isLocked());
        Assert.assertFalse((boolean)secondLock.isLocked());
        Assert.assertEquals((long)(total.committed - total.rolled), (long)queue.size());
    }

    public static void main(String[] args) throws Throwable {
        TxnQueueWithLockTest test = new TxnQueueWithLockTest();
        new TestRunner<TxnQueueWithLockTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private TxnCounter counter = new TxnCounter();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TxnQueueWithLockTest.this.testContext.isStopped()) {
                try {
                    ILock firstLock = TxnQueueWithLockTest.this.instance.getLock(TxnQueueWithLockTest.this.basename + "l1");
                    firstLock.lock();
                    TransactionContext ctx = TxnQueueWithLockTest.this.instance.newTransactionContext();
                    ctx.beginTransaction();
                    try {
                        TransactionalQueue queue = ctx.getQueue(TxnQueueWithLockTest.this.basename + "q");
                        queue.offer((Object)1);
                        ILock secondLock = TxnQueueWithLockTest.this.instance.getLock(TxnQueueWithLockTest.this.basename + "l2");
                        secondLock.lock();
                        secondLock.unlock();
                        ctx.commitTransaction();
                        ++this.counter.committed;
                    }
                    catch (Exception e) {
                        ctx.rollbackTransaction();
                        ++this.counter.rolled;
                        System.out.println(TxnQueueWithLockTest.this.basename + ": ThreadLocal txn No. " + this.counter.committed + 1 + " ThreadLocal roles =" + this.counter.rolled);
                        System.out.println(TxnQueueWithLockTest.this.basename + ": " + e);
                    }
                    finally {
                        firstLock.unlock();
                    }
                }
                catch (TargetDisconnectedException e) {
                    System.out.println((Object)e);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    System.out.println((Object)e);
                }
            }
            IList results = TxnQueueWithLockTest.this.instance.getList(TxnQueueWithLockTest.this.basename + "results");
            results.add((Object)this.counter);
        }
    }
}

