/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.queue;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import org.junit.Assert;

public class QueueTest {
    private static final ILogger log = Logger.getLogger(QueueTest.class);
    private IAtomicLong totalCounter;
    private IQueue[] queues;
    public int queueLength = 100;
    public int threadsPerQueue = 1;
    public int messagesPerQueue = 1;
    public String basename = this.getClass().getName();
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        HazelcastInstance targetInstance = testContext.getTargetInstance();
        this.totalCounter = targetInstance.getAtomicLong(testContext.getTestId() + ":TotalCounter");
        this.queues = new IQueue[this.queueLength];
        for (int k = 0; k < this.queues.length; ++k) {
            this.queues[k] = targetInstance.getQueue(this.basename + "-" + testContext.getTestId() + "-" + k);
        }
        for (IQueue queue : this.queues) {
            for (int k = 0; k < this.messagesPerQueue; ++k) {
                queue.add((Object)0L);
            }
        }
    }

    @Teardown
    public void teardown() throws Exception {
        for (IQueue queue : this.queues) {
            queue.destroy();
        }
        this.totalCounter.destroy();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int queueIndex = 0; queueIndex < this.queueLength; ++queueIndex) {
            for (int l = 0; l < this.threadsPerQueue; ++l) {
                spawner.spawn(new Worker(queueIndex));
            }
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() {
        long expected = this.totalCounter.get();
        long actual = 0L;
        for (IQueue queue : this.queues) {
            for (Long l : queue) {
                actual += l.longValue();
            }
        }
        Assert.assertEquals((long)expected, (long)actual);
    }

    public static void main(String[] args) throws Throwable {
        QueueTest test = new QueueTest();
        new TestRunner<QueueTest>(test).run();
        System.exit(0);
    }

    private class Worker
    implements Runnable {
        private final IQueue<Long> fromQueue;
        private final IQueue<Long> toQueue;

        public Worker(int fromIndex) {
            int toIndex = QueueTest.this.queueLength - 1 == fromIndex ? 0 : fromIndex + 1;
            this.fromQueue = QueueTest.this.queues[fromIndex];
            this.toQueue = QueueTest.this.queues[toIndex];
        }

        @Override
        public void run() {
            try {
                long iteration = 0L;
                while (!QueueTest.this.testContext.isStopped()) {
                    long item = (Long)this.fromQueue.take();
                    this.toQueue.put((Object)(item + 1L));
                    if (iteration % 200L == 0L) {
                        log.info(Thread.currentThread().getName() + " At iteration: " + iteration + " fromQueue size=" + this.fromQueue.size() + ", toQueue size=" + this.toQueue.size());
                    }
                    ++iteration;
                }
                this.toQueue.put((Object)0L);
                QueueTest.this.totalCounter.addAndGet(iteration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

