/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.queue;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.io.Serializable;
import java.util.Random;
import org.junit.Assert;

public class ProducerConsumerTest {
    private static final ILogger log = Logger.getLogger(ProducerConsumerTest.class);
    public int producerCount = 4;
    public int consumerCount = 4;
    public int maxIntervalMillis = 1000;
    public String basename = "queue";
    private IAtomicLong produced;
    private IQueue workQueue;
    private IAtomicLong consumed;
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        HazelcastInstance targetInstance = testContext.getTargetInstance();
        this.produced = targetInstance.getAtomicLong(this.basename + "-" + testContext.getTestId() + ":Produced");
        this.consumed = targetInstance.getAtomicLong(this.basename + "-" + testContext.getTestId() + ":Consumed");
        this.workQueue = targetInstance.getQueue(this.basename + "-" + testContext.getTestId() + ":WorkQueue");
    }

    @Teardown
    public void teardown() throws Exception {
        this.produced.destroy();
        this.workQueue.destroy();
        this.consumed.destroy();
    }

    @Run
    public void run() {
        int k;
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (k = 0; k < this.producerCount; ++k) {
            spawner.spawn("ProducerThread", new Producer(k));
        }
        for (k = 0; k < this.consumerCount; ++k) {
            spawner.spawn("ConsumerThread", new Consumer(k));
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() {
        long expected = (long)this.workQueue.size() + this.consumed.get();
        long actual = this.produced.get();
        Assert.assertEquals((long)expected, (long)actual);
    }

    public static void main(String[] args) throws Throwable {
        ProducerConsumerTest test = new ProducerConsumerTest();
        new TestRunner<ProducerConsumerTest>(test).run();
        System.exit(0);
    }

    static class Work
    implements Serializable {
        Work() {
        }
    }

    private class Consumer
    implements Runnable {
        Random rand = new Random(System.currentTimeMillis());
        int id;

        public Consumer(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            long iter = 0L;
            while (!ProducerConsumerTest.this.testContext.isStopped()) {
                try {
                    ProducerConsumerTest.this.workQueue.take();
                    ProducerConsumerTest.this.consumed.incrementAndGet();
                    Thread.sleep(this.rand.nextInt(ProducerConsumerTest.this.maxIntervalMillis) * ProducerConsumerTest.this.producerCount);
                    if (++iter % 20L != 0L) continue;
                    this.logState(iter);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void logState(long iter) {
            log.info(Thread.currentThread().getName() + " prod-id:" + this.id + " iteration: " + iter + " produced:" + ProducerConsumerTest.this.produced.get() + " workqueue:" + ProducerConsumerTest.this.workQueue.size() + " consumed:" + ProducerConsumerTest.this.consumed.get());
        }
    }

    private class Producer
    implements Runnable {
        Random rand = new Random(System.currentTimeMillis());
        int id;

        public Producer(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            long iter = 0L;
            while (!ProducerConsumerTest.this.testContext.isStopped()) {
                try {
                    Thread.sleep(this.rand.nextInt(ProducerConsumerTest.this.maxIntervalMillis) * ProducerConsumerTest.this.consumerCount);
                    ProducerConsumerTest.this.produced.incrementAndGet();
                    ProducerConsumerTest.this.workQueue.offer((Object)new Work());
                    if (++iter % 10L != 0L) continue;
                    log.info(Thread.currentThread().getName() + " prod-id:" + this.id + " iteration: " + iter + " prodoced:" + ProducerConsumerTest.this.produced.get() + " workqueue:" + ProducerConsumerTest.this.workQueue.size() + " consumed:" + ProducerConsumerTest.this.consumed.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

