/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map.helpers;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import java.util.Random;

public class StringUtils {
    private static final String alphabet = "abcdefghijklmnopqrstuvwxyz1234567890";
    private static final Random random = new Random();

    public static String generateKey(int keyLength, boolean preventLocalCalls, HazelcastInstance instance) {
        String key;
        if (!preventLocalCalls) {
            return StringUtils.makeString(keyLength);
        }
        while (StringUtils.isLocalKey(instance, key = StringUtils.makeString(keyLength))) {
        }
        return key;
    }

    private static boolean isLocalKey(HazelcastInstance instance, String key) {
        PartitionService partitionService = instance.getPartitionService();
        Partition partition = partitionService.getPartition((Object)key);
        Member owner = partition.getOwner();
        return owner.equals(instance.getLocalEndpoint());
    }

    public static String makeString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < length; ++k) {
            char c = alphabet.charAt(random.nextInt(alphabet.length()));
            sb.append(c);
        }
        return sb.toString();
    }
}

