/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map.helpers;

import com.hazelcast.core.MapStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MapStoreWithCounter
implements MapStore<Object, Object> {
    private Random random = new Random();
    public static int minDelayMs = 0;
    public static int maxDelayMs = 0;
    public final Map store = new ConcurrentHashMap();
    public AtomicInteger storeCount = new AtomicInteger(0);
    public AtomicInteger deleteCount = new AtomicInteger(0);
    public AtomicInteger countLoad = new AtomicInteger(0);

    public void store(Object key, Object value) {
        this.delay();
        this.storeCount.incrementAndGet();
        this.store.put(key, value);
    }

    public void storeAll(Map<Object, Object> map) {
        for (Map.Entry<Object, Object> kvp : map.entrySet()) {
            this.store(kvp.getKey(), kvp.getValue());
        }
    }

    public void delete(Object key) {
        this.delay();
        this.deleteCount.incrementAndGet();
        this.store.remove(key);
    }

    public void deleteAll(Collection<Object> keys) {
        for (Object key : keys) {
            this.delete(key);
        }
    }

    public Object load(Object key) {
        this.delay();
        this.countLoad.incrementAndGet();
        return this.store.get(key);
    }

    public Map<Object, Object> loadAll(Collection<Object> keys) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Object key : keys) {
            Object v = this.load(key);
            if (v == null) continue;
            result.put(key, v);
        }
        return result;
    }

    public Set<Object> loadAllKeys() {
        this.delay();
        return this.store.keySet();
    }

    private void delay() {
        if (maxDelayMs != 0) {
            try {
                int delay = minDelayMs + this.random.nextInt(maxDelayMs);
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "MapStoreWithCounter{minDelayMs=" + minDelayMs + ", maxDelayMs=" + maxDelayMs + ", storeCount=" + this.storeCount + ", deleteCount=" + this.deleteCount + ", countLoad=" + this.countLoad + '}';
    }
}

