/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map.helpers;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class EventCount
implements DataSerializable {
    public AtomicLong localAddCount = new AtomicLong(0L);
    public AtomicLong localRemoveCount = new AtomicLong(0L);
    public AtomicLong localUpdateCount = new AtomicLong(0L);
    public AtomicLong localEvictCount = new AtomicLong(0L);
    public AtomicLong localReplaceCount = new AtomicLong(0L);

    public void add(EventCount c) {
        this.localAddCount.addAndGet(c.localAddCount.get());
        this.localRemoveCount.addAndGet(c.localRemoveCount.get());
        this.localUpdateCount.addAndGet(c.localUpdateCount.get());
        this.localEvictCount.addAndGet(c.localEvictCount.get());
        this.localReplaceCount.addAndGet(c.localReplaceCount.get());
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.localAddCount);
        out.writeObject((Object)this.localRemoveCount);
        out.writeObject((Object)this.localUpdateCount);
        out.writeObject((Object)this.localEvictCount);
        out.writeObject((Object)this.localReplaceCount);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.localAddCount = (AtomicLong)in.readObject();
        this.localRemoveCount = (AtomicLong)in.readObject();
        this.localUpdateCount = (AtomicLong)in.readObject();
        this.localEvictCount = (AtomicLong)in.readObject();
        this.localReplaceCount = (AtomicLong)in.readObject();
    }

    public long total() {
        return this.localAddCount.get() + this.localRemoveCount.get() + this.localUpdateCount.get() + this.localEvictCount.get() + this.localReplaceCount.get();
    }

    public String toString() {
        return "Count{putCount=" + this.localAddCount + ", putTransientCount=" + this.localRemoveCount + ", putIfAbsentCount=" + this.localUpdateCount + ", replaceCount=" + this.localEvictCount + ", getCount=" + this.localReplaceCount + '}';
    }
}

