/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map.helpers;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class EntryListenerImpl
implements DataSerializable,
EntryListener<Object, Object> {
    private Random random = new Random();
    public AtomicLong addCount = new AtomicLong();
    public AtomicLong removeCount = new AtomicLong();
    public AtomicLong updateCount = new AtomicLong();
    public AtomicLong evictCount = new AtomicLong();
    public int minDelayMs;
    public int maxDelayMs;

    public EntryListenerImpl() {
    }

    public EntryListenerImpl(int minDelayMs, int maxDelayMs) {
        this.minDelayMs = minDelayMs;
        this.maxDelayMs = maxDelayMs;
    }

    public void entryAdded(EntryEvent<Object, Object> objectObjectEntryEvent) {
        this.delay();
        this.addCount.incrementAndGet();
    }

    public void entryRemoved(EntryEvent<Object, Object> objectObjectEntryEvent) {
        this.delay();
        this.removeCount.incrementAndGet();
    }

    public void entryUpdated(EntryEvent<Object, Object> objectObjectEntryEvent) {
        this.delay();
        this.updateCount.incrementAndGet();
    }

    public void entryEvicted(EntryEvent<Object, Object> objectObjectEntryEvent) {
        this.delay();
        this.evictCount.incrementAndGet();
    }

    private void delay() {
        if (this.maxDelayMs != 0) {
            int delayMs = this.minDelayMs + this.random.nextInt(this.maxDelayMs);
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.addCount);
        out.writeObject((Object)this.removeCount);
        out.writeObject((Object)this.updateCount);
        out.writeObject((Object)this.evictCount);
        out.writeInt(this.minDelayMs);
        out.writeInt(this.maxDelayMs);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.addCount = (AtomicLong)in.readObject();
        this.removeCount = (AtomicLong)in.readObject();
        this.updateCount = (AtomicLong)in.readObject();
        this.evictCount = (AtomicLong)in.readObject();
        this.minDelayMs = in.readInt();
        this.maxDelayMs = in.readInt();
    }

    public String toString() {
        return "EntryCounter{addCount=" + this.addCount + ", removeCount=" + this.removeCount + ", updateCount=" + this.updateCount + ", evictCount=" + this.evictCount + '}';
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof EntryListenerImpl)) {
            return false;
        }
        EntryListenerImpl that = (EntryListenerImpl)o;
        return this.addCount.get() == that.addCount.get() && this.evictCount.get() == that.evictCount.get() && this.removeCount.get() == that.removeCount.get() && this.updateCount.get() == that.updateCount.get();
    }

    public int hashCode() {
        int result = this.addCount != null ? this.addCount.hashCode() : 0;
        result = 31 * result + (this.removeCount != null ? this.removeCount.hashCode() : 0);
        result = 31 * result + (this.updateCount != null ? this.updateCount.hashCode() : 0);
        result = 31 * result + (this.evictCount != null ? this.evictCount.hashCode() : 0);
        return result;
    }
}

