/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.map.helpers.StringUtils;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class StringMapTest {
    private static final ILogger log = Logger.getLogger(StringMapTest.class);
    public int writePercentage = 10;
    public int threadCount = 10;
    public int keyLength = 10;
    public int valueLength = 10;
    public int keyCount = 10000;
    public int valueCount = 10000;
    public int logFrequency = 10000;
    public int performanceUpdateFrequency = 10000;
    public boolean usePut = true;
    public String basename = "stringmap";
    public boolean preventLocalCalls = false;
    public int minNumberOfMembers = 0;
    private IMap<Object, Object> map;
    private String[] keys;
    private String[] values;
    private final AtomicLong operations = new AtomicLong();
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        if (this.writePercentage < 0) {
            throw new IllegalArgumentException("Write percentage can't be smaller than 0");
        }
        if (this.writePercentage > 100) {
            throw new IllegalArgumentException("Write percentage can't be larger than 100");
        }
        this.testContext = testContext;
        HazelcastInstance targetInstance = testContext.getTargetInstance();
        this.map = targetInstance.getMap(this.basename + "-" + testContext.getTestId());
    }

    @Teardown
    public void teardown() throws Exception {
        this.map.destroy();
    }

    @Warmup(global=false)
    public void warmup() throws InterruptedException {
        int k;
        this.waitForCluser();
        log.info("Warmup has run");
        this.warmUpPartitions(this.testContext.getTargetInstance());
        this.keys = new String[this.keyCount];
        for (k = 0; k < this.keys.length; ++k) {
            this.keys[k] = StringUtils.generateKey(this.keyLength, this.preventLocalCalls, this.testContext.getTargetInstance());
        }
        this.values = new String[this.valueCount];
        for (k = 0; k < this.values.length; ++k) {
            this.values[k] = StringUtils.makeString(this.valueLength);
        }
        Random random = new Random();
        for (int k2 = 0; k2 < this.keys.length; ++k2) {
            String key = this.keys[random.nextInt(this.keyCount)];
            String value = this.values[random.nextInt(this.valueCount)];
            this.map.put((Object)key, (Object)value);
        }
    }

    private void waitForCluser() {
        while (this.testContext.getTargetInstance().getCluster().getMembers().size() < this.minNumberOfMembers) {
            try {
                Thread.sleep(1000L);
                System.out.println("Waiting for other cluster member. Minimum no. of member: " + this.minNumberOfMembers + ", current no. members: " + this.testContext.getTargetInstance().getCluster().getMembers().size());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    public void warmUpPartitions(HazelcastInstance ... instances) throws InterruptedException {
        for (HazelcastInstance instance : instances) {
            PartitionService ps = instance.getPartitionService();
            for (Partition partition : ps.getPartitions()) {
                while (partition.getOwner() == null) {
                    Thread.sleep(10L);
                }
            }
        }
        for (int i = 0; i < 100000; ++i) {
            this.map.get((Object)i);
        }
    }

    @Performance
    public long getOperationCount() {
        return this.operations.get();
    }

    public static void main(String[] args) throws Throwable {
        StringMapTest test = new StringMapTest();
        test.writePercentage = 10;
        new TestRunner<StringMapTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            long iteration = 0L;
            while (!StringMapTest.this.testContext.isStopped()) {
                Object key = this.randomKey();
                if (this.shouldWrite(iteration)) {
                    Object value = this.randomValue();
                    if (StringMapTest.this.usePut) {
                        StringMapTest.this.map.put(key, value);
                    } else {
                        StringMapTest.this.map.set(key, value);
                    }
                } else {
                    StringMapTest.this.map.get(key);
                }
                if (iteration % (long)StringMapTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                if (iteration % (long)StringMapTest.this.performanceUpdateFrequency == 0L) {
                    StringMapTest.this.operations.addAndGet(StringMapTest.this.performanceUpdateFrequency);
                }
                ++iteration;
            }
        }

        private Object randomValue() {
            return StringMapTest.this.values[this.random.nextInt(StringMapTest.this.values.length)];
        }

        private Object randomKey() {
            int length = StringMapTest.this.keys.length;
            return StringMapTest.this.keys[this.random.nextInt(length)];
        }

        private boolean shouldWrite(long iteration) {
            if (StringMapTest.this.writePercentage == 0) {
                return false;
            }
            if (StringMapTest.this.writePercentage == 100) {
                return true;
            }
            return iteration % 100L < (long)StringMapTest.this.writePercentage;
        }
    }
}

