/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.TransactionalTaskContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;

public class MapTransactionTest {
    private static final ILogger log = Logger.getLogger(MapTransactionTest.class);
    public int threadCount = 10;
    public int keyCount = 1000;
    public int logFrequency = 10000;
    public int performanceUpdateFrequency = 10000;
    public String basename = "txmap";
    private IMap<Integer, Long> map;
    private final AtomicLong operations = new AtomicLong();
    private IMap<String, Map<Integer, Long>> resultsPerWorker;
    private HazelcastInstance targetInstance;
    private String mapName;
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.mapName = this.basename + "-" + testContext.getTestId();
        this.map = this.targetInstance.getMap(this.mapName);
        this.resultsPerWorker = this.targetInstance.getMap(this.basename + "ResultMap" + testContext.getTestId());
    }

    @Teardown
    public void teardown() throws Exception {
        this.map.destroy();
        this.resultsPerWorker.destroy();
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        for (int k = 0; k < this.keyCount; ++k) {
            this.map.put((Object)k, (Object)0L);
        }
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() throws Exception {
        long[] amount = new long[this.keyCount];
        for (Map map : this.resultsPerWorker.values()) {
            for (Map.Entry entry : map.entrySet()) {
                int n = (Integer)entry.getKey();
                amount[n] = amount[n] + (Long)entry.getValue();
            }
        }
        int failures = 0;
        for (int k = 0; k < this.keyCount; ++k) {
            long expected = amount[k];
            long found = (Long)this.map.get((Object)k);
            if (expected == found) continue;
            ++failures;
        }
        Assert.assertEquals((String)"There should not be any data races", (long)0L, (long)failures);
    }

    @Performance
    public long getOperationCount() {
        return this.operations.get();
    }

    public static void main(String[] args) throws Throwable {
        MapTransactionTest test = new MapTransactionTest();
        new TestRunner<MapTransactionTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();
        private final Map<Integer, Long> result = new HashMap<Integer, Long>();

        private Worker() {
        }

        @Override
        public void run() {
            for (int k = 0; k < MapTransactionTest.this.keyCount; ++k) {
                this.result.put(k, 0L);
            }
            long iteration = 0L;
            while (!MapTransactionTest.this.testContext.isStopped()) {
                final Integer key = this.random.nextInt(MapTransactionTest.this.keyCount);
                final long increment = this.random.nextInt(100);
                MapTransactionTest.this.targetInstance.executeTransaction((TransactionalTask)new TransactionalTask<Object>(){

                    public Object execute(TransactionalTaskContext txContext) throws TransactionException {
                        TransactionalMap map = txContext.getMap(MapTransactionTest.this.mapName);
                        Long current = (Long)map.getForUpdate((Object)key);
                        Long update = current + increment;
                        map.put((Object)key, (Object)update);
                        return null;
                    }
                });
                this.increment(key, increment);
                if (iteration % (long)MapTransactionTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                if (iteration % (long)MapTransactionTest.this.performanceUpdateFrequency == 0L) {
                    MapTransactionTest.this.operations.addAndGet(MapTransactionTest.this.performanceUpdateFrequency);
                }
                ++iteration;
            }
            MapTransactionTest.this.resultsPerWorker.put((Object)UUID.randomUUID().toString(), this.result);
        }

        private void increment(int key, long increment) {
            this.result.put(key, this.result.get(key) + increment);
        }
    }
}

