/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.helpers.TxnCounter;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import java.util.Random;
import org.junit.Assert;

public class MapTransactionContextTest {
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int keyCount = 10;
    private HazelcastInstance targetInstance;
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        IMap map = this.targetInstance.getMap(this.basename);
        for (int k = 0; k < this.keyCount; ++k) {
            map.put((Object)k, (Object)0L);
        }
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify(global=true)
    public void verify() throws Exception {
        IList counts = this.targetInstance.getList(this.basename + "report");
        TxnCounter total = new TxnCounter();
        for (TxnCounter c : counts) {
            total.add(c);
        }
        System.out.println(this.basename + ": " + total + " from " + counts.size() + " workers");
        IList allIncrements = this.targetInstance.getList(this.basename + "res");
        long[] expected = new long[this.keyCount];
        for (long[] incs : allIncrements) {
            for (int i = 0; i < incs.length; ++i) {
                int n = i;
                expected[n] = expected[n] + incs[i];
            }
        }
        System.out.println(this.basename + ": received increments from " + allIncrements.size() + " workers");
        IMap map = this.targetInstance.getMap(this.basename);
        int failures = 0;
        for (int k = 0; k < this.keyCount; ++k) {
            if (expected[k] == (Long)map.get((Object)k)) continue;
            ++failures;
        }
        Assert.assertEquals((String)(this.basename + ": " + failures + " key=>values have been incremented unExpected"), (long)0L, (long)failures);
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();
        private final long[] localIncrements;
        private TxnCounter count;

        private Worker() {
            this.localIncrements = new long[MapTransactionContextTest.this.keyCount];
            this.count = new TxnCounter();
        }

        @Override
        public void run() {
            while (!MapTransactionContextTest.this.testContext.isStopped()) {
                try {
                    TransactionContext context = MapTransactionContextTest.this.targetInstance.newTransactionContext();
                    try {
                        context.beginTransaction();
                        TransactionalMap map = context.getMap(MapTransactionContextTest.this.basename);
                        int key = this.random.nextInt(MapTransactionContextTest.this.keyCount);
                        long increment = this.random.nextInt(100);
                        Long current = (Long)map.getForUpdate((Object)key);
                        Long update = current + increment;
                        map.put((Object)key, (Object)update);
                        context.commitTransaction();
                        int n = key;
                        this.localIncrements[n] = this.localIncrements[n] + increment;
                        ++this.count.committed;
                    }
                    catch (TransactionException e) {
                        context.rollbackTransaction();
                        ++this.count.rolled;
                        System.out.println(MapTransactionContextTest.this.basename + ": " + (Object)((Object)e));
                    }
                }
                catch (TargetDisconnectedException e) {
                    System.out.println(MapTransactionContextTest.this.basename + ": " + (Object)((Object)e));
                }
                catch (HazelcastInstanceNotActiveException e) {
                    System.out.println(MapTransactionContextTest.this.basename + ": " + (Object)((Object)e));
                }
            }
            MapTransactionContextTest.this.targetInstance.getList(MapTransactionContextTest.this.basename + "res").add((Object)this.localIncrements);
            MapTransactionContextTest.this.targetInstance.getList(MapTransactionContextTest.this.basename + "report").add((Object)this.count);
        }
    }
}

