/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.map.MapAsyncOpsTest;
import com.hazelcast.stabilizer.tests.map.helpers.MapOpperationsCount;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class MapTimeToLiveTest {
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int keyCount = 10;
    public double putTTLProb = 0.4;
    public double putAsyncTTLProb = 0.3;
    public double getProb = 0.2;
    public double getAsyncProb = 0.1;
    public double destroyProb = 0.0;
    public int maxTTLExpireyMs = 3000;
    public int minTTLExpireyMs = 1;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify(global=true)
    public void globalVerify() throws Exception {
        Thread.sleep(this.maxTTLExpireyMs * 10);
        IList results = this.targetInstance.getList(this.basename + "report");
        MapOpperationsCount total = new MapOpperationsCount();
        for (MapOpperationsCount i : results) {
            total.add(i);
        }
        System.out.println(this.basename + ": " + total + " total of " + results.size());
        IMap map = this.targetInstance.getMap(this.basename);
        for (int i = 0; i < 10; ++i) {
            if (map.size() == 0) continue;
            System.out.println(this.basename + ": map size=" + map.size());
            Thread.sleep(9000L);
        }
        Assert.assertEquals((String)"Map Size not 0, some TTL events not processed", (long)0L, (long)map.size());
    }

    public static void main(String[] args) throws Throwable {
        new TestRunner<MapAsyncOpsTest>(new MapAsyncOpsTest()).run();
    }

    private class Worker
    implements Runnable {
        private MapOpperationsCount count = new MapOpperationsCount();
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            while (!MapTimeToLiveTest.this.testContext.isStopped()) {
                try {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    int delayMs;
                    Integer value;
                    double d5;
                    int key = this.random.nextInt(MapTimeToLiveTest.this.keyCount);
                    IMap map = MapTimeToLiveTest.this.targetInstance.getMap(MapTimeToLiveTest.this.basename);
                    double chance = this.random.nextDouble();
                    chance -= MapTimeToLiveTest.this.putTTLProb;
                    if (d5 < 0.0) {
                        value = this.random.nextInt();
                        delayMs = MapTimeToLiveTest.this.minTTLExpireyMs + this.random.nextInt(MapTimeToLiveTest.this.maxTTLExpireyMs);
                        map.put((Object)key, (Object)value, (long)delayMs, TimeUnit.MILLISECONDS);
                        this.count.putTTLCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapTimeToLiveTest.this.putAsyncTTLProb;
                    if (d4 < 0.0) {
                        value = this.random.nextInt();
                        delayMs = MapTimeToLiveTest.this.minTTLExpireyMs + this.random.nextInt(MapTimeToLiveTest.this.maxTTLExpireyMs);
                        map.putAsync((Object)key, (Object)value, (long)delayMs, TimeUnit.MILLISECONDS);
                        this.count.putAsyncTTLCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapTimeToLiveTest.this.getProb;
                    if (d3 < 0.0) {
                        map.get((Object)key);
                        this.count.getCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapTimeToLiveTest.this.getAsyncProb;
                    if (d2 < 0.0) {
                        map.getAsync((Object)key);
                        this.count.getAsyncCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapTimeToLiveTest.this.destroyProb;
                    if (!(d <= 0.0)) continue;
                    map.destroy();
                    this.count.destroyCount.incrementAndGet();
                }
                catch (DistributedObjectDestroyedException e) {}
            }
            IList results = MapTimeToLiveTest.this.targetInstance.getList(MapTimeToLiveTest.this.basename + "report");
            results.add((Object)this.count);
        }
    }
}

