/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.map.helpers.MapOpperationsCount;
import com.hazelcast.stabilizer.tests.map.helpers.MapStoreWithCounter;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;

public class MapStoreTest {
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int keyCount = 10;
    public double writeProb = 0.4;
    public double getProb = 0.2;
    public double getAsyncProb = 0.15;
    public double deleteProb = 0.2;
    public double destroyProb = 0.0;
    public double writeUsingPutProb = 0.4;
    public double writeUsingPutAsyncProb = 0.0;
    public double writeUsingPutTTLProb = 0.3;
    public double writeUsingPutIfAbsent = 0.15;
    public double writeUsingReplaceProb = 0.15;
    public int mapStoreMaxDelayMs = 0;
    public int mapStoreMinDelayMs = 0;
    public int maxTTLExpireyMs = 3000;
    public int minTTLExpireyMs = 100;
    private int putTTlKeyDomain;
    private int putTTlKeyRange;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.putTTlKeyDomain = this.keyCount;
        this.putTTlKeyRange = this.keyCount;
        MapStoreWithCounter.maxDelayMs = this.mapStoreMaxDelayMs;
        MapStoreWithCounter.minDelayMs = this.mapStoreMinDelayMs;
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify(global=true)
    public void globalVerify() throws Exception {
        IList results = this.targetInstance.getList(this.basename + "report");
        MapOpperationsCount total = new MapOpperationsCount();
        for (MapOpperationsCount i : results) {
            total.add(i);
        }
        System.out.println(this.basename + ": " + total + " total of " + results.size());
    }

    @Verify(global=false)
    public void verify() throws Exception {
        try {
            MapStoreConfig mapStoreConfig = this.targetInstance.getConfig().getMapConfig(this.basename).getMapStoreConfig();
            int writeDelaySeconds = mapStoreConfig.getWriteDelaySeconds();
            Thread.sleep(this.mapStoreMaxDelayMs * 2 + this.maxTTLExpireyMs * 2 + writeDelaySeconds * 2 * 1000);
            MapStoreWithCounter mapStore = (MapStoreWithCounter)mapStoreConfig.getImplementation();
            IMap map = this.targetInstance.getMap(this.basename);
            System.out.println(this.basename + ": map size  =" + map.size());
            System.out.println(this.basename + ": map local =" + map.getAll(map.localKeySet()).entrySet());
            System.out.println(this.basename + ": map Store =" + mapStore.store.entrySet());
            System.out.println(this.basename + ": " + mapStore);
            for (Object k : map.localKeySet()) {
                Assert.assertEquals((Object)map.get(k), mapStore.store.get(k));
            }
            Assert.assertEquals((String)"sets should be equals", map.getAll(map.localKeySet()).entrySet(), mapStore.store.entrySet());
            for (int k = this.putTTlKeyDomain; k < this.putTTlKeyDomain + this.putTTlKeyRange; ++k) {
                Assert.assertNull((String)"TTL key should not be in the map", (Object)map.get((Object)k));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private class Worker
    implements Runnable {
        private MapOpperationsCount count = new MapOpperationsCount();
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            while (!MapStoreTest.this.testContext.isStopped()) {
                try {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    int key = this.random.nextInt(MapStoreTest.this.keyCount);
                    IMap map = MapStoreTest.this.targetInstance.getMap(MapStoreTest.this.basename);
                    double chance = this.random.nextDouble();
                    chance -= MapStoreTest.this.writeProb;
                    if (d5 < 0.0) {
                        Object orig;
                        double d6;
                        double d7;
                        double d8;
                        double d9;
                        double d10;
                        Integer value = this.random.nextInt();
                        chance = this.random.nextDouble();
                        chance -= MapStoreTest.this.writeUsingPutProb;
                        if (d10 < 0.0) {
                            map.put((Object)key, (Object)value);
                            this.count.putCount.incrementAndGet();
                            continue;
                        }
                        chance -= MapStoreTest.this.writeUsingPutAsyncProb;
                        if (d9 < 0.0) {
                            map.putAsync((Object)key, (Object)value);
                            this.count.putAsyncCount.incrementAndGet();
                            continue;
                        }
                        chance -= MapStoreTest.this.writeUsingPutTTLProb;
                        if (d8 < 0.0) {
                            long delayMs = MapStoreTest.this.minTTLExpireyMs + this.random.nextInt(MapStoreTest.this.maxTTLExpireyMs);
                            int k = MapStoreTest.this.putTTlKeyDomain + this.random.nextInt(MapStoreTest.this.putTTlKeyRange);
                            map.putTransient((Object)k, (Object)delayMs, delayMs, TimeUnit.MILLISECONDS);
                            this.count.putTransientCount.incrementAndGet();
                            continue;
                        }
                        chance -= MapStoreTest.this.writeUsingPutIfAbsent;
                        if (d7 < 0.0) {
                            map.putIfAbsent((Object)key, (Object)value);
                            this.count.putIfAbsentCount.incrementAndGet();
                            continue;
                        }
                        chance -= MapStoreTest.this.writeUsingReplaceProb;
                        if (!(d6 <= 0.0) || (orig = map.get((Object)key)) == null) continue;
                        map.replace((Object)key, orig, (Object)value);
                        this.count.replaceCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapStoreTest.this.getProb;
                    if (d4 < 0.0) {
                        map.get((Object)key);
                        this.count.getCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapStoreTest.this.getAsyncProb;
                    if (d3 < 0.0) {
                        map.getAsync((Object)key);
                        this.count.getAsyncCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapStoreTest.this.deleteProb;
                    if (d2 < 0.0) {
                        map.delete((Object)key);
                        this.count.deleteCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapStoreTest.this.destroyProb;
                    if (!(d <= 0.0)) continue;
                    map.destroy();
                    this.count.destroyCount.incrementAndGet();
                }
                catch (DistributedObjectDestroyedException e) {}
            }
            IList results = MapStoreTest.this.targetInstance.getList(MapStoreTest.this.basename + "report");
            results.add((Object)this.count);
        }
    }
}

