/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.map.helpers.MapOpperationsCount;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class MapMaxSizeTest {
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int keyCount = Integer.MAX_VALUE;
    public double writeProb = 0.5;
    public double getProb = 0.5;
    public double writeUsingPutProb = 0.6;
    public double writeUsingPutAsyncProb = 0.2;
    public double writeUsingPutTTLProb = 0.2;
    public int maxTTLExpireyMs = 3000;
    public int minTTLExpireyMs = 100;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify(global=true)
    public void globalVerify() throws Exception {
        IList results = this.targetInstance.getList(this.basename + "report");
        MapOpperationsCount total = new MapOpperationsCount();
        for (MapOpperationsCount i : results) {
            total.add(i);
        }
        System.out.println(this.basename + ": " + total + " total of " + results.size());
        IMap map = this.targetInstance.getMap(this.basename);
        System.out.println(this.basename + ": Map size = " + map.size());
    }

    @Verify(global=false)
    public void verify() throws Exception {
        try {
            MaxSizeConfig maxSizeConfig = this.targetInstance.getConfig().getMapConfig(this.basename).getMaxSizeConfig();
            IMap map = this.targetInstance.getMap(this.basename);
            System.out.println(maxSizeConfig);
            System.out.println(this.basename + ": Map size = " + map.size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private class Worker
    implements Runnable {
        private MapOpperationsCount count = new MapOpperationsCount();
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            while (!MapMaxSizeTest.this.testContext.isStopped()) {
                try {
                    double d;
                    double d2;
                    int key = this.random.nextInt(MapMaxSizeTest.this.keyCount);
                    IMap map = MapMaxSizeTest.this.targetInstance.getMap(MapMaxSizeTest.this.basename);
                    double chance = this.random.nextDouble();
                    chance -= MapMaxSizeTest.this.writeProb;
                    if (d2 < 0.0) {
                        double d3;
                        double d4;
                        double d5;
                        Integer value = this.random.nextInt();
                        chance = this.random.nextDouble();
                        chance -= MapMaxSizeTest.this.writeUsingPutProb;
                        if (d5 < 0.0) {
                            map.put((Object)key, (Object)value);
                            this.count.putCount.incrementAndGet();
                            continue;
                        }
                        chance -= MapMaxSizeTest.this.writeUsingPutAsyncProb;
                        if (d4 < 0.0) {
                            map.putAsync((Object)key, (Object)value);
                            this.count.putAsyncCount.incrementAndGet();
                            continue;
                        }
                        chance -= MapMaxSizeTest.this.writeUsingPutTTLProb;
                        if (!(d3 < 0.0)) continue;
                        long delayMs = MapMaxSizeTest.this.minTTLExpireyMs + this.random.nextInt(MapMaxSizeTest.this.maxTTLExpireyMs);
                        map.put((Object)key, (Object)delayMs, delayMs, TimeUnit.MILLISECONDS);
                        this.count.putTTLCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapMaxSizeTest.this.getProb;
                    if (!(d < 0.0)) continue;
                    map.get((Object)key);
                    this.count.getCount.incrementAndGet();
                }
                catch (DistributedObjectDestroyedException e) {}
            }
            IList results = MapMaxSizeTest.this.targetInstance.getList(MapMaxSizeTest.this.basename + "report");
            results.add((Object)this.count);
        }
    }
}

