/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class MapLongPerformanceTest {
    private static final ILogger log = Logger.getLogger(MapLongPerformanceTest.class);
    public int threadCount = 10;
    public int keyCount = 1000000;
    public int logFrequency = 10000;
    public int performanceUpdateFrequency = 10000;
    public String basename = "maplong";
    public int writePercentage = 10;
    private IMap<Integer, Long> map;
    private final AtomicLong operations = new AtomicLong();
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        if (this.writePercentage < 0) {
            throw new IllegalArgumentException("Write percentage can't be smaller than 0");
        }
        if (this.writePercentage > 100) {
            throw new IllegalArgumentException("Write percentage can't be larger than 100");
        }
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.map = this.targetInstance.getMap(this.basename + "-" + testContext.getTestId());
    }

    @Teardown
    public void teardown() throws Exception {
        this.map.destroy();
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        for (int k = 0; k < this.keyCount; ++k) {
            this.map.put((Object)k, (Object)0L);
        }
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Performance
    public long getOperationCount() {
        return this.operations.get();
    }

    public static void main(String[] args) throws Throwable {
        MapLongPerformanceTest test = new MapLongPerformanceTest();
        new TestRunner<MapLongPerformanceTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();
        private final Map<Integer, Long> result = new HashMap<Integer, Long>();

        private Worker() {
        }

        @Override
        public void run() {
            for (int k = 0; k < MapLongPerformanceTest.this.keyCount; ++k) {
                this.result.put(k, 0L);
            }
            long iteration = 0L;
            while (!MapLongPerformanceTest.this.testContext.isStopped()) {
                Integer key = this.random.nextInt(MapLongPerformanceTest.this.keyCount);
                if (this.shouldWrite(iteration)) {
                    MapLongPerformanceTest.this.map.set((Object)key, (Object)System.currentTimeMillis());
                } else {
                    MapLongPerformanceTest.this.map.get((Object)key);
                }
                if (iteration % (long)MapLongPerformanceTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                if (iteration % (long)MapLongPerformanceTest.this.performanceUpdateFrequency == 0L) {
                    MapLongPerformanceTest.this.operations.addAndGet(MapLongPerformanceTest.this.performanceUpdateFrequency);
                }
                ++iteration;
            }
        }

        private boolean shouldWrite(long iteration) {
            if (MapLongPerformanceTest.this.writePercentage == 0) {
                return false;
            }
            if (MapLongPerformanceTest.this.writePercentage == 100) {
                return true;
            }
            return iteration % 100L < (long)MapLongPerformanceTest.this.writePercentage;
        }
    }
}

