/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.query.EntryObject;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.SqlPredicate;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.map.helpers.Employee;
import com.hazelcast.stabilizer.tests.map.helpers.OppCounterIdxTest;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Collection;
import java.util.Random;

public class MapIndexTest {
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int keyCount = 100;
    public double predicateBuilder = 0.2;
    public double sqlString = 0.2;
    public double pagePred = 0.2;
    public double updateEmploye = 0.3;
    public double destroyProb = 0.1;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
    }

    @Warmup(global=true)
    public void globalWarmup() {
        this.initMap();
    }

    private void initMap() {
        IMap map = this.targetInstance.getMap(this.basename);
        for (int i = 0; i < this.keyCount; ++i) {
            map.put((Object)i, (Object)new Employee(i));
        }
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        map.addIndex("id", true);
        map.addIndex("name", true);
        map.addIndex("age", true);
        map.addIndex("salary", true);
        map.addIndex("active", false);
        free = Runtime.getRuntime().freeMemory();
        total = Runtime.getRuntime().totalMemory();
        used = total - free;
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify(global=true)
    public void globalVerify() throws Exception {
        IList counters = this.targetInstance.getList(this.basename + "report");
        OppCounterIdxTest total = new OppCounterIdxTest();
        for (OppCounterIdxTest c : counters) {
            total.add(c);
        }
        System.out.println(this.basename + " " + total + " from " + counters.size());
    }

    public static void main(String[] args) throws Throwable {
        new TestRunner<MapIndexTest>(new MapIndexTest()).run();
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();
        private OppCounterIdxTest counter = new OppCounterIdxTest();

        private Worker() {
        }

        @Override
        public void run() {
            while (!MapIndexTest.this.testContext.isStopped()) {
                try {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    IMap map = MapIndexTest.this.targetInstance.getMap(MapIndexTest.this.basename);
                    double chance = this.random.nextDouble();
                    chance -= MapIndexTest.this.predicateBuilder;
                    if (d5 < 0.0) {
                        int age = this.random.nextInt(75);
                        String name = Employee.names[this.random.nextInt(Employee.names.length)];
                        EntryObject entryObject = new PredicateBuilder().getEntryObject();
                        PredicateBuilder agePredicate = entryObject.get("age").lessThan((Comparable)Integer.valueOf(age));
                        PredicateBuilder predicate = entryObject.get("name").equal((Comparable)((Object)name)).and((Predicate)agePredicate);
                        Collection employees = map.values((Predicate)predicate);
                        ++this.counter.predicateBuilderCount;
                        for (Employee emp : employees) {
                            if (emp.getAge() < age && name.equals(emp.getName())) continue;
                            System.out.println(MapIndexTest.this.basename + " ERROR: " + emp + " not matching predicate " + predicate);
                        }
                        continue;
                    }
                    chance -= MapIndexTest.this.sqlString;
                    if (d4 < 0.0) {
                        boolean active = this.random.nextBoolean();
                        int age = this.random.nextInt(75);
                        SqlPredicate predicate = new SqlPredicate("active=" + active + " AND age >" + age);
                        Collection employees = map.values((Predicate)predicate);
                        ++this.counter.sqlStringCount;
                        for (Employee emp : employees) {
                            if (active == emp.isActive() && emp.getAge() > age) continue;
                            System.out.println(MapIndexTest.this.basename + " ERROR: " + emp + " not matching predicate " + predicate);
                        }
                        continue;
                    }
                    chance -= MapIndexTest.this.pagePred;
                    if (d3 < 0.0) {
                        Collection employees;
                        double maxSal = this.random.nextDouble() * 1000.0;
                        Predicate pred = Predicates.lessThan((String)"salary", (Comparable)Double.valueOf(maxSal));
                        PagingPredicate pagingPredicate = new PagingPredicate(pred, 5);
                        System.out.println(MapIndexTest.this.basename + " start-loop");
                        do {
                            employees = map.values((Predicate)pagingPredicate);
                            for (Employee emp : employees) {
                            }
                            pagingPredicate.nextPage();
                            if (!MapIndexTest.this.testContext.isStopped()) continue;
                            System.out.println(MapIndexTest.this.basename + "(stop) res size = " + employees.size());
                        } while (!employees.isEmpty());
                        System.out.println(MapIndexTest.this.basename + " end-loop");
                        ++this.counter.pagePredCount;
                        continue;
                    }
                    chance -= MapIndexTest.this.updateEmploye;
                    if (d2 < 0.0) {
                        int key = this.random.nextInt(MapIndexTest.this.keyCount);
                        Employee e = (Employee)map.get((Object)key);
                        if (e == null) continue;
                        e.setInfo();
                        map.put((Object)key, (Object)e);
                        ++this.counter.updateEmployeCount;
                        continue;
                    }
                    chance -= MapIndexTest.this.destroyProb;
                    if (!(d < 0.0)) continue;
                    map.destroy();
                    MapIndexTest.this.initMap();
                    ++this.counter.destroyCount;
                }
                catch (DistributedObjectDestroyedException distributedObjectDestroyedException) {}
            }
            MapIndexTest.this.targetInstance.getList(MapIndexTest.this.basename + "report").add((Object)this.counter);
        }
    }
}

