/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.AbstractEntryProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;

public class MapEntryProcessorTest {
    private static final ILogger log = Logger.getLogger(MapEntryProcessorTest.class);
    public String basename = this.getClass().getName();
    public int threadCount = 10;
    public int keyCount = 1000;
    public int minProcessorDelayMs = 0;
    public int maxProcessorDealyMs = 0;
    private IMap<Integer, Long> map;
    private IList<Map<Integer, Long>> resultsPerWorker;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.map = this.targetInstance.getMap(this.basename + "-" + testContext.getTestId());
        this.resultsPerWorker = this.targetInstance.getList(this.basename + "ResultMap" + testContext.getTestId());
    }

    @Teardown
    public void teardown() throws Exception {
        this.map.destroy();
        this.resultsPerWorker.destroy();
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        for (int k = 0; k < this.keyCount; ++k) {
            this.map.put((Object)k, (Object)0L);
        }
        System.out.println(this.basename + " map size ==>" + this.map.size());
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() throws Exception {
        long[] amount = new long[this.keyCount];
        for (Map map : this.resultsPerWorker) {
            for (Map.Entry entry : map.entrySet()) {
                int n = (Integer)entry.getKey();
                amount[n] = amount[n] + (Long)entry.getValue();
            }
        }
        int failures = 0;
        for (int k = 0; k < this.keyCount; ++k) {
            long expected = amount[k];
            long found = (Long)this.map.get((Object)k);
            if (expected == found) continue;
            ++failures;
        }
        Assert.assertEquals((long)0L, (long)failures);
    }

    public static void main(String[] args) throws Throwable {
        MapEntryProcessorTest test = new MapEntryProcessorTest();
        new TestRunner<MapEntryProcessorTest>(test).run();
    }

    private static class IncrementEntryProcessor
    extends AbstractEntryProcessor<Integer, Long> {
        private final long increment;
        private final long delayMs;

        private IncrementEntryProcessor(long increment, long delayMs) {
            this.increment = increment;
            this.delayMs = delayMs;
        }

        public Object process(Map.Entry<Integer, Long> entry) {
            this.delay();
            long newValue = entry.getValue() + this.increment;
            entry.setValue(newValue);
            return null;
        }

        private void delay() {
            if (this.delayMs != 0L) {
                try {
                    Thread.sleep(this.delayMs);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();
        private final Map<Integer, Long> result = new HashMap<Integer, Long>();

        public Worker() {
            for (int k = 0; k < MapEntryProcessorTest.this.keyCount; ++k) {
                this.result.put(k, 0L);
            }
        }

        @Override
        public void run() {
            while (!MapEntryProcessorTest.this.testContext.isStopped()) {
                int key = this.random.nextInt(MapEntryProcessorTest.this.keyCount);
                long increment = this.random.nextInt(100);
                int delayMs = 0;
                if (MapEntryProcessorTest.this.maxProcessorDealyMs != 0) {
                    delayMs = MapEntryProcessorTest.this.minProcessorDelayMs + this.random.nextInt(MapEntryProcessorTest.this.maxProcessorDealyMs);
                }
                MapEntryProcessorTest.this.map.executeOnKey((Object)key, (EntryProcessor)new IncrementEntryProcessor(increment, delayMs));
                this.increment(key, increment);
            }
            try {
                Thread.sleep(MapEntryProcessorTest.this.maxProcessorDealyMs * 2);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            MapEntryProcessorTest.this.resultsPerWorker.add(this.result);
        }

        private void increment(int key, long increment) {
            this.result.put(key, this.result.get(key) + increment);
        }
    }
}

