/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.map.helpers.EntryListenerImpl;
import com.hazelcast.stabilizer.tests.map.helpers.EventCount;
import com.hazelcast.stabilizer.tests.map.helpers.ScrambledZipfianGenerator;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import org.junit.Assert;

public class MapEntryListenerTest {
    private static final String alphabet = "abcdefghijklmnopqrstuvwxyz1234567890";
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int valueLength = 100;
    public int keyCount = 1000;
    public int valueCount = 1000;
    public boolean randomDistributionUniform = false;
    public int maxEntryListenerDelayMs = 0;
    public int minEntryListenerDelayMs = 0;
    public double writeProb = 0.4;
    public double evictProb = 0.2;
    public double removeProb = 0.2;
    public double deleteProb = 0.2;
    public double writeUsingPutProb = 0.5;
    public double writeUsingPutIfAbsent = 0.25;
    public double replaceProb = 0.25;
    private String[] values;
    private TestContext testContext;
    private HazelcastInstance targetInstance;
    private EntryListenerImpl listener;
    private ScrambledZipfianGenerator kesyZipfian = new ScrambledZipfianGenerator(this.keyCount);
    private int sleepMs_CatchEvents = 8000;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.values = new String[this.valueCount];
        for (int k = 0; k < this.values.length; ++k) {
            this.values[k] = this.makeString(this.valueLength);
        }
        IMap map = this.targetInstance.getMap(this.basename);
        this.listener = new EntryListenerImpl(this.minEntryListenerDelayMs, this.maxEntryListenerDelayMs);
        map.addEntryListener((EntryListener)this.listener, true);
    }

    @Warmup(global=true)
    public void globalWarmup() {
        IMap map = this.targetInstance.getMap(this.basename);
        EventCount initCounter = new EventCount();
        int v = 0;
        for (int k = 0; k < this.keyCount; ++k) {
            map.put((Object)k, (Object)this.values[v]);
            initCounter.localAddCount.getAndIncrement();
            v = v + 1 == this.values.length ? 0 : v + 1;
        }
        IList results = this.targetInstance.getList(this.basename + "eventCount");
        results.add((Object)initCounter);
    }

    private String makeString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < length; ++k) {
            char c = alphabet.charAt(random.nextInt(alphabet.length()));
            sb.append(c);
        }
        return sb.toString();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
        try {
            Thread.sleep(this.sleepMs_CatchEvents);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IList resultListners = this.targetInstance.getList(this.basename + "listeners");
        resultListners.add((Object)this.listener);
    }

    @Teardown(global=true)
    public void tearDown() throws Exception {
        IMap map = this.targetInstance.getMap(this.basename);
        map.destroy();
    }

    @Verify(global=true)
    public void golbalVerify() throws Exception {
        IList resultListners = this.targetInstance.getList(this.basename + "listeners");
        for (int i = 0; i < resultListners.size() - 1; ++i) {
            EntryListenerImpl a = (EntryListenerImpl)resultListners.get(i);
            EntryListenerImpl b = (EntryListenerImpl)resultListners.get(i + 1);
            Assert.assertEquals((String)"not same amount of event in all listeners", (Object)a, (Object)b);
        }
    }

    @Verify(global=false)
    public void verify() throws Exception {
        IList eventCounts = this.targetInstance.getList(this.basename + "eventCount");
        EventCount total = new EventCount();
        for (EventCount c : eventCounts) {
            total.add(c);
        }
        IMap map = this.targetInstance.getMap(this.basename);
        EntryListenerImpl e = this.listener;
        long expectedMapSz = e.addCount.get() - (e.evictCount.get() + e.removeCount.get());
        System.out.println(this.basename + ": add = " + total.localAddCount.get() + " " + e.addCount.get());
        System.out.println(this.basename + ": update = " + total.localUpdateCount.get() + " " + e.updateCount.get());
        System.out.println(this.basename + ": remove = " + total.localRemoveCount.get() + " " + e.removeCount.get());
        System.out.println(this.basename + ": evict = " + total.localEvictCount.get() + " " + e.evictCount.get());
        System.out.println(this.basename + ": mapSZ = " + map.size() + " " + expectedMapSz);
        Thread.sleep(9000L);
        Assert.assertEquals((String)" Add Events ", (long)total.localAddCount.get(), (long)e.addCount.get());
        Assert.assertEquals((String)" Update Events ", (long)total.localUpdateCount.get(), (long)e.updateCount.get());
        Assert.assertEquals((String)" Remove Events ", (long)total.localRemoveCount.get(), (long)e.removeCount.get());
        Assert.assertEquals((String)" Evict Events ", (long)total.localEvictCount.get(), (long)e.evictCount.get());
        Assert.assertEquals((String)" MapSZ ", (long)expectedMapSz, (long)map.size());
    }

    public static void main(String[] args) throws Throwable {
        new TestRunner<MapEntryListenerTest>(new MapEntryListenerTest()).run();
    }

    private class Worker
    implements Runnable {
        private EventCount eventCount = new EventCount();
        private final Random random = new Random();
        int key;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!MapEntryListenerTest.this.testContext.isStopped()) {
                this.key = MapEntryListenerTest.this.randomDistributionUniform ? this.random.nextInt(MapEntryListenerTest.this.keyCount) : MapEntryListenerTest.this.kesyZipfian.nextInt();
                IMap map = MapEntryListenerTest.this.targetInstance.getMap(MapEntryListenerTest.this.basename);
                double chance = this.random.nextDouble();
                if (chance < MapEntryListenerTest.this.writeProb) {
                    Object orig;
                    String value = MapEntryListenerTest.this.values[this.random.nextInt(MapEntryListenerTest.this.values.length)];
                    chance = this.random.nextDouble();
                    if (chance < MapEntryListenerTest.this.writeUsingPutProb) {
                        map.lock((Object)this.key);
                        try {
                            if (map.containsKey((Object)this.key)) {
                                this.eventCount.localUpdateCount.getAndIncrement();
                            } else {
                                this.eventCount.localAddCount.getAndIncrement();
                            }
                            map.put((Object)this.key, (Object)value);
                            continue;
                        }
                        finally {
                            map.unlock((Object)this.key);
                            continue;
                        }
                    }
                    if (chance < MapEntryListenerTest.this.writeUsingPutIfAbsent + MapEntryListenerTest.this.writeUsingPutProb) {
                        map.lock((Object)this.key);
                        try {
                            if (map.putIfAbsent((Object)this.key, (Object)value) != null) continue;
                            this.eventCount.localAddCount.getAndIncrement();
                            continue;
                        }
                        finally {
                            map.unlock((Object)this.key);
                            continue;
                        }
                    }
                    if (!(chance < MapEntryListenerTest.this.replaceProb + MapEntryListenerTest.this.writeUsingPutIfAbsent + MapEntryListenerTest.this.writeUsingPutProb) || (orig = map.get((Object)this.key)) == null || !map.replace((Object)this.key, orig, (Object)value)) continue;
                    this.eventCount.localUpdateCount.getAndIncrement();
                    continue;
                }
                if (chance < MapEntryListenerTest.this.evictProb + MapEntryListenerTest.this.writeProb) {
                    map.lock((Object)this.key);
                    try {
                        if (map.containsKey((Object)this.key)) {
                            this.eventCount.localEvictCount.getAndIncrement();
                        }
                        map.evict((Object)this.key);
                        continue;
                    }
                    finally {
                        map.unlock((Object)this.key);
                        continue;
                    }
                }
                if (chance < MapEntryListenerTest.this.removeProb + MapEntryListenerTest.this.evictProb + MapEntryListenerTest.this.writeProb) {
                    Object o = map.remove((Object)this.key);
                    if (o == null) continue;
                    this.eventCount.localRemoveCount.getAndIncrement();
                    continue;
                }
                if (!(chance < MapEntryListenerTest.this.deleteProb + MapEntryListenerTest.this.removeProb + MapEntryListenerTest.this.evictProb + MapEntryListenerTest.this.writeProb)) continue;
                map.lock((Object)this.key);
                try {
                    if (map.containsKey((Object)this.key)) {
                        this.eventCount.localRemoveCount.getAndIncrement();
                    }
                    map.delete((Object)this.key);
                }
                finally {
                    map.unlock((Object)this.key);
                }
            }
            IList results = MapEntryListenerTest.this.targetInstance.getList(MapEntryListenerTest.this.basename + "eventCount");
            results.add((Object)this.eventCount);
        }
    }
}

