/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;

public class MapCasTest {
    private static final ILogger log = Logger.getLogger(MapCasTest.class);
    public int threadCount = 10;
    public int keyCount = 1000;
    public int logFrequency = 10000;
    public int performanceUpdateFrequency = 10000;
    public String basename = "mapcas";
    private IMap<Integer, Long> map;
    private final AtomicLong operations = new AtomicLong();
    private IMap<String, Map<Integer, Long>> resultsPerWorker;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.map = this.targetInstance.getMap(this.basename + "-" + testContext.getTestId());
        this.resultsPerWorker = this.targetInstance.getMap("ResultMap" + testContext.getTestId());
    }

    @Teardown
    public void teardown() throws Exception {
        this.map.destroy();
        this.resultsPerWorker.destroy();
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        for (int k = 0; k < this.keyCount; ++k) {
            this.map.put((Object)k, (Object)0L);
        }
    }

    @Run
    public void run() {
        if (this.map.size() != this.keyCount) {
            throw new RuntimeException("warmup has not run since the map is not filled correctly, found size:" + this.map.size());
        }
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() throws Exception {
        long[] amount = new long[this.keyCount];
        for (Map map : this.resultsPerWorker.values()) {
            for (Map.Entry entry : map.entrySet()) {
                int n = (Integer)entry.getKey();
                amount[n] = amount[n] + (Long)entry.getValue();
            }
        }
        int failures = 0;
        for (int k = 0; k < this.keyCount; ++k) {
            long expected = amount[k];
            long found = (Long)this.map.get((Object)k);
            if (expected == found) continue;
            ++failures;
        }
        Assert.assertEquals((String)"There should not be any data races", (long)0L, (long)failures);
    }

    @Performance
    public long getOperationCount() {
        return this.operations.get();
    }

    public static void main(String[] args) throws Throwable {
        MapCasTest test = new MapCasTest();
        new TestRunner<MapCasTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();
        private final Map<Integer, Long> result = new HashMap<Integer, Long>();

        private Worker() {
        }

        @Override
        public void run() {
            for (int k = 0; k < MapCasTest.this.keyCount; ++k) {
                this.result.put(k, 0L);
            }
            long iteration = 0L;
            while (!MapCasTest.this.testContext.isStopped()) {
                Long update;
                Long current;
                Integer key = this.random.nextInt(MapCasTest.this.keyCount);
                long increment = this.random.nextInt(100);
                do {
                    current = (Long)MapCasTest.this.map.get((Object)key);
                    update = current + increment;
                } while (!MapCasTest.this.map.replace((Object)key, (Object)current, (Object)update));
                this.increment(key, increment);
                if (iteration % (long)MapCasTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                if (iteration % (long)MapCasTest.this.performanceUpdateFrequency == 0L) {
                    MapCasTest.this.operations.addAndGet(MapCasTest.this.performanceUpdateFrequency);
                }
                ++iteration;
            }
            MapCasTest.this.resultsPerWorker.put((Object)UUID.randomUUID().toString(), this.result);
        }

        private void increment(int key, long increment) {
            this.result.put(key, this.result.get(key) + increment);
        }
    }
}

