/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.map.helpers.MapOpperationsCount;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class MapAsyncOpsTest {
    public String basename = this.getClass().getName();
    public int threadCount = 3;
    public int keyCount = 10;
    public double PutAsyncProb = 0.2;
    public double PutAsyncTTLProb = 0.2;
    public double getAsyncProb = 0.2;
    public double removeAsyncProb = 0.2;
    public double destroyProb = 0.2;
    public int maxTTLExpireySeconds = 3;
    private TestContext testContext;
    private HazelcastInstance targetInstance;
    private MapOpperationsCount count = new MapOpperationsCount();

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
        IList results = this.targetInstance.getList(this.basename + "report");
        results.add((Object)this.count);
    }

    @Verify(global=true)
    public void globalVerify() throws Exception {
        IList results = this.targetInstance.getList(this.basename + "report");
        MapOpperationsCount total = new MapOpperationsCount();
        for (MapOpperationsCount i : results) {
            total.add(i);
        }
        System.out.println(this.basename + ": " + total + " total of " + results.size());
    }

    @Verify(global=false)
    public void verify() throws Exception {
        try {
            Thread.sleep(this.maxTTLExpireySeconds * 2);
            IMap map = this.targetInstance.getMap(this.basename);
            System.out.println(this.basename + ": map size  =" + map.size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Throwable {
        new TestRunner<MapAsyncOpsTest>(new MapAsyncOpsTest()).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            while (!MapAsyncOpsTest.this.testContext.isStopped()) {
                try {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    Integer value;
                    double d5;
                    int key = this.random.nextInt(MapAsyncOpsTest.this.keyCount);
                    IMap map = MapAsyncOpsTest.this.targetInstance.getMap(MapAsyncOpsTest.this.basename);
                    double chance = this.random.nextDouble();
                    chance -= MapAsyncOpsTest.this.PutAsyncProb;
                    if (d5 < 0.0) {
                        value = this.random.nextInt();
                        map.putAsync((Object)key, (Object)value);
                        ((MapAsyncOpsTest)MapAsyncOpsTest.this).count.putAsyncCount.incrementAndGet();
                    }
                    chance -= MapAsyncOpsTest.this.PutAsyncTTLProb;
                    if (d4 < 0.0) {
                        value = this.random.nextInt();
                        int delay = 1 + this.random.nextInt(MapAsyncOpsTest.this.maxTTLExpireySeconds);
                        map.putAsync((Object)key, (Object)value, (long)delay, TimeUnit.SECONDS);
                        ((MapAsyncOpsTest)MapAsyncOpsTest.this).count.putAsyncTTLCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapAsyncOpsTest.this.getAsyncProb;
                    if (d3 < 0.0) {
                        map.getAsync((Object)key);
                        ((MapAsyncOpsTest)MapAsyncOpsTest.this).count.getAsyncCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapAsyncOpsTest.this.removeAsyncProb;
                    if (d2 < 0.0) {
                        map.removeAsync((Object)key);
                        ((MapAsyncOpsTest)MapAsyncOpsTest.this).count.removeAsyncCount.incrementAndGet();
                        continue;
                    }
                    chance -= MapAsyncOpsTest.this.destroyProb;
                    if (!(d <= 0.0)) continue;
                    map.destroy();
                    ((MapAsyncOpsTest)MapAsyncOpsTest.this).count.destroyCount.incrementAndGet();
                }
                catch (DistributedObjectDestroyedException distributedObjectDestroyedException) {}
            }
        }
    }
}

