/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import org.junit.Assert;

public class GrowingMapTest {
    private static final ILogger log = Logger.getLogger(GrowingMapTest.class);
    public int threadCount = 10;
    public int growCount = 10000;
    public boolean usePut = true;
    public boolean useRemove = true;
    public int logFrequency = 10000;
    public boolean removeOnStop = true;
    public boolean readValidation = true;
    public String basename = "growningmap";
    private IMap<Long, Long> map;
    private IdGenerator idGenerator;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.idGenerator = this.targetInstance.getIdGenerator(testContext.getTestId() + ":IdGenerator");
        this.map = this.targetInstance.getMap(this.basename + "-" + testContext.getTestId());
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Teardown
    public void teardown() throws Exception {
    }

    @Verify
    public void verify() throws Exception {
        if (this.removeOnStop) {
            Assert.assertEquals((String)"Map should be empty, but has size:", (long)0L, (long)this.map.size());
            Assert.assertTrue((String)"Map should be empty, but has size:", (boolean)this.map.isEmpty());
        }
    }

    public static void main(String[] args) throws Throwable {
        GrowingMapTest test = new GrowingMapTest();
        new TestRunner<GrowingMapTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            long insertIteration = 0L;
            long deleteIteration = 0L;
            long readIteration = 0L;
            long[] keys = new long[GrowingMapTest.this.growCount];
            long[] values = new long[GrowingMapTest.this.growCount];
            Random random = new Random();
            while (!GrowingMapTest.this.testContext.isStopped()) {
                long found;
                long value;
                long key;
                int k;
                int keyIndex = -1;
                for (k = 0; k < GrowingMapTest.this.growCount && !GrowingMapTest.this.testContext.isStopped(); ++k) {
                    key = GrowingMapTest.this.idGenerator.newId();
                    value = random.nextLong();
                    keyIndex = k;
                    keys[keyIndex] = key;
                    values[keyIndex] = value;
                    if (GrowingMapTest.this.usePut) {
                        GrowingMapTest.this.map.put((Object)key, (Object)value);
                    } else {
                        GrowingMapTest.this.map.set((Object)key, (Object)value);
                    }
                    if (++insertIteration % (long)GrowingMapTest.this.logFrequency != 0L) continue;
                    log.info(Thread.currentThread().getName() + " At insert iteration: " + insertIteration);
                }
                if (GrowingMapTest.this.readValidation) {
                    for (k = 0; k <= keyIndex && !GrowingMapTest.this.testContext.isStopped(); ++k) {
                        key = keys[k];
                        value = values[k];
                        found = (Long)GrowingMapTest.this.map.get((Object)key);
                        if (found != value) {
                            throw new RuntimeException("Unexpected value found");
                        }
                        if (++readIteration % (long)GrowingMapTest.this.logFrequency != 0L) continue;
                        log.info(Thread.currentThread().getName() + " At read iteration: " + readIteration);
                    }
                }
                for (k = 0; k <= keyIndex && (!GrowingMapTest.this.testContext.isStopped() || GrowingMapTest.this.removeOnStop); ++k) {
                    key = keys[k];
                    value = values[k];
                    if (GrowingMapTest.this.useRemove) {
                        found = (Long)GrowingMapTest.this.map.remove((Object)key);
                        if (found != value) {
                            throw new RuntimeException("Unexpected value found");
                        }
                    } else {
                        GrowingMapTest.this.map.delete((Object)key);
                    }
                    if (++deleteIteration % (long)GrowingMapTest.this.logFrequency != 0L) continue;
                    log.info(Thread.currentThread().getName() + " At delete iteration: " + deleteIteration);
                }
            }
        }
    }
}

