/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.executor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class ExecutorTest {
    private static final ILogger log = Logger.getLogger(ExecutorTest.class);
    public int executorCount = 1;
    public int threadCount = 5;
    public int submitCount = 5;
    public String basename = this.getClass().getName();
    private IExecutorService[] executors;
    private IAtomicLong executedCounter;
    private IAtomicLong expectedExecutedCounter;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.executors = new IExecutorService[this.executorCount];
        for (int k = 0; k < this.executors.length; ++k) {
            this.executors[k] = this.targetInstance.getExecutorService(this.basename + "-" + testContext.getTestId() + "-" + k);
        }
        this.executedCounter = this.targetInstance.getAtomicLong(testContext.getTestId() + ":ExecutedCounter");
        this.expectedExecutedCounter = this.targetInstance.getAtomicLong(testContext.getTestId() + ":ExpectedExecutedCounter");
    }

    @Teardown(global=true)
    public void teardown() throws Exception {
        this.executedCounter.destroy();
        this.expectedExecutedCounter.destroy();
        for (IExecutorService executor : this.executors) {
            executor.shutdownNow();
            if (!executor.awaitTermination(120L, TimeUnit.SECONDS)) {
                log.severe("Time out while waiting for  shutdown of executor: " + executor.getId());
            }
            executor.destroy();
        }
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() throws Exception {
        long actual = this.executedCounter.get();
        long expected = this.expectedExecutedCounter.get();
        Assert.assertEquals((long)expected, (long)actual);
    }

    public static void main(String[] args) throws Throwable {
        ExecutorTest test = new ExecutorTest();
        new TestRunner<ExecutorTest>(test).run();
    }

    private static class Task
    implements Runnable,
    Serializable,
    HazelcastInstanceAware {
        private transient HazelcastInstance hz;
        private final String testId;

        private Task(String testId) {
            this.testId = testId;
        }

        @Override
        public void run() {
            ExecutorTest test = (ExecutorTest)this.hz.getUserContext().get("testInstance:" + this.testId);
            test.executedCounter.incrementAndGet();
        }

        public void setHazelcastInstance(HazelcastInstance hz) {
            this.hz = hz;
        }
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            long iteration = 0L;
            LinkedList<Future> futureList = new LinkedList<Future>();
            while (!ExecutorTest.this.testContext.isStopped()) {
                int index = this.random.nextInt(ExecutorTest.this.executors.length);
                IExecutorService executorService = ExecutorTest.this.executors[index];
                futureList.clear();
                for (int k = 0; k < ExecutorTest.this.submitCount; ++k) {
                    Future future = executorService.submit((Runnable)new Task(ExecutorTest.this.testContext.getTestId()));
                    futureList.add(future);
                    ++iteration;
                }
                for (Future future : futureList) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (iteration % 10000L != 0L) continue;
                log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
            }
            ExecutorTest.this.expectedExecutedCounter.addAndGet(iteration);
        }
    }
}

