/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.concurrent.lock;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import org.junit.Assert;

public class SimpleLockTest {
    private static final ILogger log = Logger.getLogger(SimpleLockTest.class);
    public int maxAccounts = 7;
    public int threadCount = 10;
    public int logFrequency = 10000;
    private String basename = this.getClass().getName();
    private int initialValue = 1000;
    private int totalValue = 0;
    private TestContext testContext;
    private HazelcastInstance targetInstance;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        for (int k = 0; k < this.maxAccounts; ++k) {
            IAtomicLong account = this.targetInstance.getAtomicLong(this.basename + k);
            account.set((long)this.initialValue);
        }
        this.totalValue = this.initialValue * this.maxAccounts;
    }

    @Verify
    public void verify() {
        int value = 0;
        for (int k = 0; k < this.maxAccounts; ++k) {
            ILock lock = this.targetInstance.getLock(this.basename + k);
            IAtomicLong account = this.targetInstance.getAtomicLong(this.basename + k);
            System.out.println(account + " " + account.get());
            Assert.assertFalse((String)"Lock should be unlocked", (boolean)lock.isLocked());
            Assert.assertTrue((String)"Amount is < 0 ", (account.get() >= 0L ? 1 : 0) != 0);
            value = (int)((long)value + account.get());
        }
        Assert.assertEquals((long)this.totalValue, (long)value);
    }

    @Teardown
    public void teardown() throws Exception {
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    public static void main(String[] args) throws Throwable {
        SimpleLockTest test = new SimpleLockTest();
        new TestRunner<SimpleLockTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long iteration = 0L;
            while (!SimpleLockTest.this.testContext.isStopped()) {
                block11: {
                    int key2;
                    int key1 = this.random.nextInt(SimpleLockTest.this.maxAccounts);
                    while (key1 == (key2 = this.random.nextInt(SimpleLockTest.this.maxAccounts))) {
                    }
                    ILock lock1 = SimpleLockTest.this.targetInstance.getLock(SimpleLockTest.this.basename + key1);
                    if (lock1.tryLock()) {
                        try {
                            ILock lock2 = SimpleLockTest.this.targetInstance.getLock(SimpleLockTest.this.basename + key2);
                            if (!lock2.tryLock()) break block11;
                            try {
                                IAtomicLong account1 = SimpleLockTest.this.targetInstance.getAtomicLong(SimpleLockTest.this.basename + key1);
                                IAtomicLong account2 = SimpleLockTest.this.targetInstance.getAtomicLong(SimpleLockTest.this.basename + key2);
                                int delta = this.random.nextInt(100);
                                if (account1.get() >= (long)delta) {
                                    account1.set(account1.get() - (long)delta);
                                    account2.set(account2.get() + (long)delta);
                                }
                            }
                            finally {
                                lock2.unlock();
                            }
                        }
                        finally {
                            lock1.unlock();
                        }
                    }
                }
                if (iteration % (long)SimpleLockTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                ++iteration;
            }
        }
    }
}

