/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.concurrent.lock;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.annotations.Warmup;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import org.junit.Assert;

public class LockTest {
    private static final ILogger log = Logger.getLogger(LockTest.class);
    public int lockCount = 500;
    public int threadCount = 10;
    public int initialAmount = 1000;
    public int amount = 50;
    public int logFrequency = 1000;
    private IAtomicLong lockCounter;
    private IAtomicLong totalMoney;
    private HazelcastInstance targetInstance;
    public String basename = "lock";
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        this.targetInstance = testContext.getTargetInstance();
        this.lockCounter = this.targetInstance.getAtomicLong(testContext.getTestId() + ":LockCounter");
        this.totalMoney = this.targetInstance.getAtomicLong(testContext.getTestId() + ":TotalMoney");
    }

    @Warmup(global=true)
    public void warmup() throws Exception {
        for (int k = 0; k < this.lockCount; ++k) {
            long key = this.lockCounter.getAndIncrement();
            this.targetInstance.getLock(this.getLockId(key));
            IAtomicLong account = this.targetInstance.getAtomicLong(this.getAccountId(key));
            account.set((long)this.initialAmount);
            this.totalMoney.addAndGet((long)this.initialAmount);
        }
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    private String getLockId(long key) {
        return this.basename + "-" + this.testContext.getTestId() + "-" + key;
    }

    private String getAccountId(long key) {
        return this.basename + "-" + this.testContext.getTestId() + "-" + key;
    }

    @Verify
    public void verify() {
        long actual = 0L;
        for (long k = 0L; k < this.lockCounter.get(); ++k) {
            ILock lock = this.targetInstance.getLock(this.getLockId(k));
            Assert.assertFalse((String)"Lock should be unlocked", (boolean)lock.isLocked());
            IAtomicLong account = this.targetInstance.getAtomicLong(this.getAccountId(k));
            Assert.assertTrue((String)"Amount can't be smaller than zero on account", (account.get() >= 0L ? 1 : 0) != 0);
            actual += account.get();
        }
        long expected = this.totalMoney.get();
        Assert.assertEquals((String)"Money was lost/created", (long)expected, (long)actual);
    }

    @Teardown
    public void teardown() throws Exception {
        this.lockCounter.destroy();
        this.totalMoney.destroy();
        for (long k = 0L; k < this.lockCounter.get(); ++k) {
            this.targetInstance.getLock(this.getLockId(k)).destroy();
            this.targetInstance.getAtomicLong(this.getAccountId(k)).destroy();
        }
    }

    public static void main(String[] args) throws Throwable {
        LockTest test = new LockTest();
        new TestRunner<LockTest>(test).withDuration(10).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long iteration = 0L;
            while (!LockTest.this.testContext.isStopped()) {
                long key1 = this.getRandomAccountKey();
                long key2 = this.getRandomAccountKey();
                int a = this.random.nextInt(LockTest.this.amount);
                IAtomicLong account1 = LockTest.this.targetInstance.getAtomicLong(LockTest.this.getAccountId(key1));
                ILock lock1 = LockTest.this.targetInstance.getLock(LockTest.this.getLockId(key1));
                IAtomicLong account2 = LockTest.this.targetInstance.getAtomicLong(LockTest.this.getAccountId(key2));
                ILock lock2 = LockTest.this.targetInstance.getLock(LockTest.this.getLockId(key2));
                if (!lock1.tryLock()) continue;
                try {
                    if (!lock2.tryLock()) continue;
                    try {
                        if (account1.get() < 0L || account2.get() < 0L) {
                            throw new RuntimeException("Amount on account can't be smaller than 0");
                        }
                        if (account1.get() < (long)a) continue;
                        account1.set(account1.get() - (long)a);
                        account2.set(account2.get() + (long)a);
                    }
                    finally {
                        lock2.unlock();
                        continue;
                    }
                }
                finally {
                    lock1.unlock();
                    continue;
                }
                if (iteration % (long)LockTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                ++iteration;
            }
            LockTest.this.totalMoney.addAndGet(iteration);
        }

        private long getRandomAccountKey() {
            long key = this.random.nextLong() % LockTest.this.lockCounter.get();
            if (key < 0L) {
                key = -key;
            }
            return key;
        }
    }
}

