/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests.concurrent.atomiclong;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;

public class AtomicLongTest {
    private static final ILogger log = Logger.getLogger(AtomicLongTest.class);
    public int countersLength = 1000;
    public int threadCount = 1;
    public int logFrequency = 10000;
    public int performanceUpdateFrequency = 10000;
    public String basename = "atomiclong";
    private IAtomicLong totalCounter;
    private IAtomicLong[] counters;
    private AtomicLong operations = new AtomicLong();
    private TestContext context;

    @Setup
    public void setup(TestContext context) throws Exception {
        this.context = context;
        log.info("countersLength:" + this.countersLength + " threadCount:" + this.threadCount);
        HazelcastInstance targetInstance = context.getTargetInstance();
        this.totalCounter = targetInstance.getAtomicLong(context.getTestId() + ":TotalCounter");
        this.counters = new IAtomicLong[this.countersLength];
        for (int k = 0; k < this.counters.length; ++k) {
            this.counters[k] = targetInstance.getAtomicLong(this.basename + "-" + context.getTestId() + "r-" + k);
        }
    }

    @Teardown
    public void teardown() throws Exception {
        for (IAtomicLong counter : this.counters) {
            counter.destroy();
        }
        this.totalCounter.destroy();
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.context.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() {
        long expected = this.totalCounter.get();
        long actual = 0L;
        for (IAtomicLong counter : this.counters) {
            actual += counter.get();
        }
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Performance
    public long getOperationCount() {
        return this.operations.get();
    }

    public static void main(String[] args) throws Throwable {
        AtomicLongTest test = new AtomicLongTest();
        new TestRunner<AtomicLongTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private final Random random = new Random();

        private Worker() {
        }

        @Override
        public void run() {
            long iteration = 0L;
            while (!AtomicLongTest.this.context.isStopped()) {
                IAtomicLong counter = this.getRandomCounter();
                counter.incrementAndGet();
                if (iteration % (long)AtomicLongTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                if (iteration % (long)AtomicLongTest.this.performanceUpdateFrequency == 0L) {
                    AtomicLongTest.this.operations.addAndGet(AtomicLongTest.this.performanceUpdateFrequency);
                }
                ++iteration;
            }
            AtomicLongTest.this.totalCounter.addAndGet(iteration);
        }

        private IAtomicLong getRandomCounter() {
            int index = this.random.nextInt(AtomicLongTest.this.counters.length);
            return AtomicLongTest.this.counters[index];
        }
    }
}

