/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests;

import com.hazelcast.stabilizer.TestCase;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.tests.Failure;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TestSuite
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String id = "" + System.currentTimeMillis();
    public List<TestCase> testCaseList = new LinkedList<TestCase>();
    public int duration;
    public boolean failFast;
    public Set<Failure.Type> tolerableFailures = Collections.EMPTY_SET;

    public static TestSuite loadTestSuite(File file) throws Exception {
        Properties properties = Utils.loadProperties(file);
        HashMap<String, TestCase> testcases = new HashMap<String, TestCase>();
        for (String property : properties.stringPropertyNames()) {
            TestCase testCase;
            String value = (String)properties.get(property);
            int indexOfDot = property.indexOf(".");
            String testCaseId = "";
            String field = property;
            if (indexOfDot > -1) {
                testCaseId = property.substring(0, indexOfDot);
                field = property.substring(indexOfDot + 1);
            }
            if ((testCase = (TestCase)testcases.get(testCaseId)) == null) {
                testCase = new TestCase();
                testCase.id = testCaseId;
                testcases.put(testCaseId, testCase);
            }
            testCase.setProperty(field, value);
        }
        LinkedList testcaseIds = new LinkedList(testcases.keySet());
        Collections.sort(testcaseIds);
        TestSuite testSuite = new TestSuite();
        for (String testcaseId : testcaseIds) {
            TestCase testcase = (TestCase)testcases.get(testcaseId);
            if (testcase.getClassname() == null) {
                if ("".equals(testcaseId)) {
                    throw new RuntimeException(String.format("There is no class set for the in property file [%s].Add class=YourTestClass", file.getAbsolutePath()));
                }
                throw new RuntimeException(String.format("There is no class set for test [%s] in property file [%s].Add %s.class=YourTestClass", testcaseId, file.getAbsolutePath(), testcaseId));
            }
            testSuite.addTest(testcase);
        }
        return testSuite;
    }

    public TestCase getTestCase(String testCaseId) {
        if (testCaseId == null) {
            return null;
        }
        for (TestCase testCase : this.testCaseList) {
            if (!testCaseId.equals(testCase.getId())) continue;
            return testCase;
        }
        return null;
    }

    public void addTest(TestCase testCase) {
        this.testCaseList.add(testCase);
    }

    public int size() {
        return this.testCaseList.size();
    }

    public String toString() {
        return "TestSuite{duration=" + this.duration + ", id='" + this.id + '\'' + ", testRecipeList=" + this.testCaseList + ", failFast=" + this.failFast + '}';
    }
}

