/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.worker.TestContainer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

public class TestRunner<E> {
    private static final ILogger log = Logger.getLogger(TestRunner.class);
    private final E test;
    private final TestContainer testInvoker;
    private HazelcastInstance hazelcastInstance;
    private int durationSeconds = 60;
    private final TestContextImpl testContext = new TestContextImpl();

    public TestRunner(E test) {
        if (test == null) {
            throw new NullPointerException("test can't be null");
        }
        this.test = test;
        this.testInvoker = new TestContainer<TestContextImpl>(test, this.testContext);
    }

    public E getTest() {
        return this.test;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public TestRunner withHazelcastInstance(HazelcastInstance hz) {
        if (hz == null) {
            throw new NullPointerException("hz can't be null");
        }
        this.hazelcastInstance = hz;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestRunner withHazelcastConfig(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file can't be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("file [%s] doesn't exist", file.getAbsolutePath()));
        }
        FileInputStream fis = new FileInputStream(file);
        try {
            Config config = new XmlConfigBuilder((InputStream)fis).build();
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config);
            TestRunner testRunner = this;
            return testRunner;
        }
        finally {
            Utils.closeQuietly((Closeable)fis);
        }
    }

    public TestRunner withDuration(int durationSeconds) {
        if (durationSeconds < 0) {
            throw new IllegalArgumentException("Duration can't be smaller than 0");
        }
        this.durationSeconds = durationSeconds;
        return this;
    }

    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    public void run() throws Throwable {
        if (this.hazelcastInstance == null) {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance();
        }
        log.info("Starting setup");
        this.testInvoker.setup();
        log.info("Finished setup");
        log.info("Starting local warmup");
        this.testInvoker.localWarmup();
        log.info("Finished local warmup");
        log.info("Starting global warmup");
        this.testInvoker.globalWarmup();
        log.info("Finished global warmup");
        log.info("Starting run");
        this.testContext.stopped = false;
        new StopThread().start();
        this.testInvoker.run();
        log.info("Finshed run");
        log.info("Starting globalVerify");
        this.testInvoker.globalVerify();
        log.info("Finished globalVerify");
        log.info("Starting localVerify");
        this.testInvoker.localVerify();
        log.info("Finished localVerify");
        log.info("Starting globalTearDown");
        this.testInvoker.globalTeardown();
        log.info("Finished globalTearDown");
        log.info("Starting local teardown");
        this.testInvoker.localTeardown();
        log.info("Finished local teardown");
        this.hazelcastInstance.shutdown();
        log.info("Finished");
    }

    private class TestContextImpl
    implements TestContext {
        final String testId = UUID.randomUUID().toString();
        volatile boolean stopped;

        private TestContextImpl() {
        }

        @Override
        public HazelcastInstance getTargetInstance() {
            return TestRunner.this.hazelcastInstance;
        }

        @Override
        public String getTestId() {
            return this.testId;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void stop() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private class StopThread
    extends Thread {
        private StopThread() {
        }

        @Override
        public void run() {
            int period = 5;
            int big = TestRunner.this.durationSeconds / period;
            int small = TestRunner.this.durationSeconds % period;
            for (int k = 1; k <= big; ++k) {
                Utils.sleepSeconds(period);
                int elapsed = period * k;
                float percentage = 100.0f * (float)elapsed / (float)TestRunner.this.durationSeconds;
                String msg = String.format("Running %s of %s seconds %-4.2f percent complete", elapsed, TestRunner.this.durationSeconds, Float.valueOf(percentage));
                log.info(msg);
            }
            Utils.sleepSeconds(small);
            log.info("Notified test to stop");
            ((TestRunner)TestRunner.this).testContext.stopped = true;
        }
    }
}

