/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests;

import com.hazelcast.stabilizer.TestCase;
import com.hazelcast.stabilizer.tests.TestSuite;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Failure
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String message;
    public Type type;
    public String agentAddress;
    public String workerAddress;
    public String workerId;
    public Date time = new Date();
    public String testId;
    public TestSuite testSuite;
    public String cause;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Failure[\n");
        sb.append("   message='").append(this.message).append("'\n");
        sb.append("   type='").append((Object)this.type).append("'\n");
        sb.append("   agentAddress=").append(this.agentAddress).append("\n");
        sb.append("   time=").append(this.time).append("\n");
        sb.append("   workerAddress=").append(this.workerAddress).append("\n");
        sb.append("   workerId=").append(this.workerId).append("\n");
        TestCase testCase = this.testSuite.getTestCase(this.testId);
        if (testCase != null) {
            String[] testString = testCase.toString().split("\n");
            sb.append("   test=").append(testString[0]).append("\n");
            for (int k = 1; k < testString.length; ++k) {
                sb.append("    ").append(testString[k]).append("\n");
            }
        } else {
            sb.append("   test=").append(this.testId + " unknown").append("\n");
        }
        if (this.cause != null) {
            sb.append("   cause=").append(this.cause).append("\n");
        } else {
            sb.append("   cause=").append("null").append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum Type {
        WORKER_EXCEPTION("Worker exception", "workerException"),
        WORKER_TIMEOUT("Worker timeout", "workerTimeout"),
        WORKER_OOM("Worker Out Of Memory Error", "workerOOM"),
        WORKER_EXIT("Worker exit", "workerExit");

        private String humanReadable;
        private String id;

        private Type(String humanReadable, String id) {
            this.humanReadable = humanReadable;
            this.id = id;
        }

        public String toString() {
            return this.humanReadable;
        }

        public static Set<Type> fromPropertyValue(String propertyValue) {
            if (propertyValue == null || propertyValue.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Type> result = new HashSet<Type>();
            StringTokenizer tokenizer = new StringTokenizer(propertyValue, ",");
            while (tokenizer.hasMoreTokens()) {
                String id = tokenizer.nextToken().trim();
                Type failureType = Type.getById(id);
                result.add(failureType);
            }
            return result;
        }

        public static String getIdsAsString() {
            Type[] types = Type.values();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                builder.append(types[i].id);
                if (i >= types.length - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }

        public String getId() {
            return this.id;
        }

        private static Type getById(String id) {
            for (Type type : Type.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown failure ID: '" + id + "'.");
        }
    }
}

