/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.tests;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.tests.TestContext;
import com.hazelcast.stabilizer.tests.TestRunner;
import com.hazelcast.stabilizer.tests.annotations.Performance;
import com.hazelcast.stabilizer.tests.annotations.Run;
import com.hazelcast.stabilizer.tests.annotations.Setup;
import com.hazelcast.stabilizer.tests.annotations.Teardown;
import com.hazelcast.stabilizer.tests.annotations.Verify;
import com.hazelcast.stabilizer.tests.utils.ThreadSpawner;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;

public class ExampleTest {
    private static final ILogger log = Logger.getLogger(ExampleTest.class);
    public int threadCount = 1;
    public int logFrequency = 10000;
    public int performanceUpdateFrequency = 10000;
    private IAtomicLong totalCounter;
    private AtomicLong operations = new AtomicLong();
    private IAtomicLong counter;
    private TestContext testContext;

    @Setup
    public void setup(TestContext testContext) throws Exception {
        this.testContext = testContext;
        HazelcastInstance targetInstance = testContext.getTargetInstance();
        this.totalCounter = targetInstance.getAtomicLong("totalCounter");
        this.counter = targetInstance.getAtomicLong("counter");
    }

    @Run
    public void run() {
        ThreadSpawner spawner = new ThreadSpawner(this.testContext.getTestId());
        for (int k = 0; k < this.threadCount; ++k) {
            spawner.spawn(new Worker());
        }
        spawner.awaitCompletion();
    }

    @Verify
    public void verify() {
        long expected = this.totalCounter.get();
        long actual = this.counter.get();
        Assert.assertEquals((long)expected, (long)actual);
    }

    @Teardown
    public void teardown() throws Exception {
        this.counter.destroy();
        this.totalCounter.destroy();
    }

    @Performance
    public long getOperationCount() {
        return this.operations.get();
    }

    public static void main(String[] args) throws Throwable {
        ExampleTest test = new ExampleTest();
        new TestRunner<ExampleTest>(test).run();
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            long iteration = 0L;
            while (!ExampleTest.this.testContext.isStopped()) {
                ExampleTest.this.counter.incrementAndGet();
                if (iteration % (long)ExampleTest.this.logFrequency == 0L) {
                    log.info(Thread.currentThread().getName() + " At iteration: " + iteration);
                }
                if (iteration % (long)ExampleTest.this.performanceUpdateFrequency == 0L) {
                    ExampleTest.this.operations.addAndGet(ExampleTest.this.performanceUpdateFrequency);
                }
                ++iteration;
            }
            ExampleTest.this.totalCounter.addAndGet(iteration);
        }
    }
}

