/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import com.hazelcast.stabilizer.provisioner.Provisioner;
import java.util.ArrayList;
import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

public class TemplateBuilder {
    private static final ILogger log = Logger.getLogger(Provisioner.class);
    private final ComputeService compute;
    private final StabilizerProperties props;
    private String machineSpec;
    private String securityGroup;
    private TemplateBuilderSpec spec;

    public TemplateBuilder(ComputeService compute, StabilizerProperties properties) {
        this.compute = compute;
        this.props = properties;
    }

    public Template build() {
        this.machineSpec = this.props.get("MACHINE_SPEC", "");
        log.info("Machine spec: " + this.machineSpec);
        this.securityGroup = this.props.get("SECURITY_GROUP", "stabilizer");
        this.spec = TemplateBuilderSpec.parse((String)this.machineSpec);
        this.initSecurityGroup();
        Template template = this.buildTemplate();
        log.info("Created template");
        String user = this.props.get("USER", "stabilizer");
        AdminAccess adminAccess = AdminAccess.builder().adminUsername(user).build();
        log.info("Loginname to the remote machines: " + user);
        template.getOptions().inboundPorts(this.inboundPorts()).runScript((Statement)adminAccess).securityGroups(new String[]{this.securityGroup});
        return template;
    }

    private Template buildTemplate() {
        try {
            return this.compute.templateBuilder().from(this.spec).build();
        }
        catch (IllegalArgumentException e) {
            log.finest((Throwable)e);
            Utils.exitWithError(log, e.getMessage());
            return null;
        }
    }

    private int[] inboundPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(22);
        ports.add(9000);
        ports.add(9001);
        for (int k = 5701; k < 5751; ++k) {
            ports.add(k);
        }
        int[] result = new int[ports.size()];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (Integer)ports.get(k);
        }
        return result;
    }

    private void initSecurityGroup() {
        Set securityGroups;
        if (!"aws-ec2".equals(this.props.get("CLOUD_PROVIDER"))) {
            return;
        }
        AWSEC2Api ec2Api = (AWSEC2Api)this.compute.getContext().unwrapApi(AWSEC2Api.class);
        SecurityGroupApi securityGroupApi = (SecurityGroupApi)ec2Api.getSecurityGroupApi().get();
        String region = this.spec.getLocationId();
        if (region == null) {
            region = "us-east-1";
        }
        if (!(securityGroups = securityGroupApi.describeSecurityGroupsInRegion(region, new String[]{this.securityGroup})).isEmpty()) {
            log.info("Security group: '" + this.securityGroup + "' is found in region '" + region + "'");
            return;
        }
        log.info("Security group: '" + this.securityGroup + "' is not found in region '" + region + "', creating it on the fly");
        securityGroupApi.createSecurityGroupInRegion(region, this.securityGroup, this.securityGroup);
        securityGroupApi.authorizeSecurityGroupIngressInRegion(region, this.securityGroup, IpProtocol.TCP, 22, 22, "0.0.0.0/0");
        securityGroupApi.authorizeSecurityGroupIngressInRegion(region, this.securityGroup, IpProtocol.TCP, 9000, 9001, "0.0.0.0/0");
        securityGroupApi.authorizeSecurityGroupIngressInRegion(region, this.securityGroup, IpProtocol.TCP, 5701, 5751, "0.0.0.0/0");
    }
}

