/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.provisioner.Provisioner;
import java.io.File;
import java.io.OutputStream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class ProvisionerCli {
    private static final ILogger log = Logger.getLogger(ProvisionerCli.class);
    public final OptionParser parser = new OptionParser();
    public final OptionSpec restartSpec = this.parser.accepts("restart", "Restarts all agents");
    public final OptionSpec downloadSpec = this.parser.accepts("download", "Download all the files from the workers directory. To delete all worker directories, run with --clean");
    public final OptionSpec cleanSpec = this.parser.accepts("clean", "Cleans the workers directories. ");
    public final OptionSpec<Integer> scaleSpec = this.parser.accepts("scale", "Number of agent machines to scale to. If the number of machines already exists, the call is ignored. If the desired number of machines is smaller than the actual number of machines, machines are terminated.").withRequiredArg().ofType(Integer.class);
    public final OptionSpec terminateSpec = this.parser.accepts("terminate", "Terminate all agent machines in the provisioner");
    public final OptionSpec killSpec = this.parser.accepts("kill", "Kill all the agent processes");
    public final OptionSpec listAgentsSpec = this.parser.accepts("list-agents", "Lists the running agents.");
    public final OptionSpec helpSpec = this.parser.accepts("help", "Show help").forHelp();
    private final OptionSpec<String> propertiesFileSpec = this.parser.accepts("propertiesFile", "The file containing the stabilizer properties. If no file is explicitly configured, first the working directory is checked for a file 'stabilizer.properties'. All missing propertiesare always loaded from STABILIZER_HOME/conf/stabilizer.properties").withRequiredArg().ofType(String.class);
    private final Provisioner provisioner;
    private OptionSet options;

    public ProvisionerCli(Provisioner provisioner) {
        this.provisioner = provisioner;
    }

    public void run(String[] args) throws Exception {
        try {
            this.options = this.parser.parse(args);
        }
        catch (OptionException e) {
            Utils.exitWithError(log, e.getMessage() + ". Use --help to get overview of the help options.");
            return;
        }
        if (this.options.has(this.helpSpec)) {
            this.parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        this.provisioner.props.init(this.getPropertiesFile());
        this.provisioner.init();
        if (this.options.has(this.restartSpec)) {
            this.provisioner.restart();
            this.provisioner.startAgents();
        } else if (this.options.has(this.killSpec)) {
            this.provisioner.killAgents();
        } else if (this.options.has(this.downloadSpec)) {
            this.provisioner.download();
        } else if (this.options.has(this.cleanSpec)) {
            this.provisioner.clean();
        } else if (this.options.has(this.terminateSpec)) {
            this.provisioner.terminate();
        } else if (this.options.has(this.scaleSpec)) {
            int size = (Integer)this.options.valueOf(this.scaleSpec);
            this.provisioner.scale(size);
        } else if (this.options.has(this.listAgentsSpec)) {
            this.provisioner.listAgents();
        } else {
            this.parser.printHelpOn((OutputStream)System.out);
        }
    }

    private File getPropertiesFile() {
        if (this.options.has(this.propertiesFileSpec)) {
            return Utils.newFile((String)this.options.valueOf(this.propertiesFileSpec));
        }
        return null;
    }
}

