/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.google.common.base.Predicate;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.AgentAddress;
import com.hazelcast.stabilizer.common.AgentsFile;
import com.hazelcast.stabilizer.common.GitInfo;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import com.hazelcast.stabilizer.provisioner.Bash;
import com.hazelcast.stabilizer.provisioner.ComputeServiceBuilder;
import com.hazelcast.stabilizer.provisioner.HazelcastJars;
import com.hazelcast.stabilizer.provisioner.ProvisionerCli;
import com.hazelcast.stabilizer.provisioner.TemplateBuilder;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;

public class Provisioner {
    private static final ILogger log = Logger.getLogger(Provisioner.class);
    public final StabilizerProperties props = new StabilizerProperties();
    private static final String STABILIZER_HOME = Utils.getStablizerHome().getAbsolutePath();
    private File agentsFile = new File("agents.txt");
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final List<AgentAddress> addresses = Collections.synchronizedList(new LinkedList());
    private Bash bash;
    private HazelcastJars hazelcastJars;

    void init() throws Exception {
        if (!this.agentsFile.exists()) {
            this.agentsFile.createNewFile();
        }
        this.addresses.addAll(AgentsFile.load(this.agentsFile));
        this.bash = new Bash(this.props);
        String hzVersionSpec = this.props.get("HAZELCAST_VERSION_SPEC", "outofthebox");
        this.hazelcastJars = new HazelcastJars(this.bash, hzVersionSpec);
    }

    void installAgent(String ip) {
        this.bash.ssh(ip, String.format("mkdir -p hazelcast-stabilizer-%s", Utils.getVersion()));
        this.bash.sshQuiet(ip, String.format("rm -fr hazelcast-stabilizer-%s/lib", Utils.getVersion()));
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/bin/", "bin");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/conf/", "conf");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/jdk-install/", "jdk-install");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/lib/hazelcast*", "lib");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/lib/jopt*", "lib");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/lib/junit*", "lib");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/lib/log4j*", "lib");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/lib/stabilizer*", "lib");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/lib/commons-lang3*", "lib");
        this.bash.copyToAgentStabilizerDir(ip, STABILIZER_HOME + "/tests/", "tests");
        String versionSpec = this.props.get("HAZELCAST_VERSION_SPEC", "outofthebox");
        if (!versionSpec.equals("outofthebox")) {
            this.bash.ssh(ip, String.format("rm -fr hazelcast-stabilizer-%s/lib/hazelcast-*.jar", Utils.getVersion()));
            if (!versionSpec.endsWith("bringmyown")) {
                this.bash.scpToRemote(ip, this.hazelcastJars.getAbsolutePath() + "/*.jar", String.format("hazelcast-stabilizer-%s/lib", Utils.getVersion()));
            }
        }
    }

    public void startAgents() {
        this.echoImportant("Starting %s Agents", this.addresses.size());
        for (AgentAddress address : this.addresses) {
            this.echo("Killing Agent %s", address.publicAddress);
            this.bash.ssh(address.publicAddress, "killall -9 java || true");
        }
        for (AgentAddress address : this.addresses) {
            this.echo("Starting Agent %s", address.publicAddress);
            this.bash.ssh(address.publicAddress, String.format("nohup hazelcast-stabilizer-%s/bin/agent --cloudProvider %s --cloudIdentity %s --cloudCredential %s> agent.out 2> agent.err < /dev/null &", Utils.getVersion(), this.props.get("CLOUD_PROVIDER"), this.props.get("CLOUD_IDENTITY"), this.props.get("CLOUD_CREDENTIAL")));
        }
        this.echoImportant("Successfully started %s Agents", this.addresses.size());
    }

    void startAgent(String ip) {
        this.bash.ssh(ip, "killall -9 java || true");
        this.bash.ssh(ip, String.format("nohup hazelcast-stabilizer-%s/bin/agent -cloudProvider %s --cloudIdentity %s --cloudCredential %s> agent.out 2> agent.err < /dev/null &", Utils.getVersion(), this.props.get("CLOUD_PROVIDER"), this.props.get("CLOUD_IDENTITY"), this.props.get("CLOUD_CREDENTIAL")));
    }

    void killAgents() {
        this.echoImportant("Killing %s Agents", this.addresses.size());
        for (AgentAddress address : this.addresses) {
            this.echo("Killing Agent, %s", address.publicAddress);
            this.bash.ssh(address.publicAddress, "killall -9 java || true");
        }
        this.echoImportant("Successfully killed %s Agents", this.addresses.size());
    }

    public void restart() {
        this.echoImportant("Restarting %s Agents", this.addresses.size());
        this.hazelcastJars.prepare();
        for (AgentAddress address : this.addresses) {
            this.echo("Installing agent: " + address.publicAddress, new Object[0]);
            this.installAgent(address.publicAddress);
        }
        this.echoImportant("Restarting %s Agents", this.addresses.size());
    }

    public void scale(int size) throws Exception {
        int delta = size - this.addresses.size();
        if (delta == 0) {
            this.echo("Current number of machines: " + this.addresses.size(), new Object[0]);
            this.echo("Desired number of machines: " + (this.addresses.size() + delta), new Object[0]);
            this.echo("Ignoring spawn machines, desired number of machines already exists.", new Object[0]);
        } else if (delta < 0) {
            this.terminate(-delta);
        } else {
            this.scaleUp(delta);
        }
    }

    private void scaleUp(int delta) throws Exception {
        this.echoImportant("Provisioning %s %s machines", delta, this.props.get("CLOUD_PROVIDER"));
        this.echo("Current number of machines: " + this.addresses.size(), new Object[0]);
        this.echo("Desired number of machines: " + (this.addresses.size() + delta), new Object[0]);
        String groupName = this.props.get("GROUP_NAME", "stabilizer-agent");
        this.echo("GroupName: " + groupName, new Object[0]);
        long startTimeMs = System.currentTimeMillis();
        String jdkFlavor = this.props.get("JDK_FLAVOR", "outofthebox");
        if ("outofthebox".equals(jdkFlavor)) {
            log.info("JDK spec: outofthebox");
        } else {
            String jdkVersion = this.props.get("JDK_VERSION", "7");
            log.info(String.format("JDK spec: %s %s", jdkFlavor, jdkVersion));
        }
        this.hazelcastJars.prepare();
        ComputeService compute = new ComputeServiceBuilder(this.props).build();
        this.echo("Created compute", new Object[0]);
        Template template = new TemplateBuilder(compute, this.props).build();
        this.echo("Creating machines (can take a few minutes)", new Object[0]);
        HashSet futures = new HashSet();
        for (int batch : this.calcBatches(delta)) {
            Set nodes = compute.createNodesInGroup(groupName, batch, template);
            for (NodeMetadata node : nodes) {
                String privateIpAddress = (String)node.getPrivateAddresses().iterator().next();
                String publicIpAddress = (String)node.getPublicAddresses().iterator().next();
                this.echo("\t" + publicIpAddress + " LAUNCHED", new Object[0]);
                Utils.appendText(publicIpAddress + "," + privateIpAddress + "\n", this.agentsFile);
                AgentAddress address = new AgentAddress(publicIpAddress, privateIpAddress);
                this.addresses.add(address);
            }
            for (NodeMetadata node : nodes) {
                String publicIpAddress = (String)node.getPublicAddresses().iterator().next();
                Future<?> f = this.executor.submit(new InstallNodeTask(publicIpAddress));
                futures.add(f);
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                log.severe("Failed provision", (Throwable)e);
                System.exit(1);
            }
        }
        long durationMs = System.currentTimeMillis() - startTimeMs;
        this.echo("Duration: " + Utils.secondsToHuman(TimeUnit.MILLISECONDS.toSeconds(durationMs)), new Object[0]);
        this.echoImportant(String.format("Successfully provisioned %s %s machines", delta, this.props.get("CLOUD_PROVIDER")), new Object[0]);
        this.echo("Pausing for Machine Warm up... (10 sec)", new Object[0]);
        Thread.sleep(10000L);
    }

    public void listAgents() {
        this.echo("Running Agents (from agents.txt):", new Object[0]);
        String agents = Utils.fileAsText(this.agentsFile);
        this.echo("\t" + agents, new Object[0]);
    }

    private int[] calcBatches(int size) {
        LinkedList<Integer> batches = new LinkedList<Integer>();
        int batchSize = Integer.parseInt(this.props.get("CLOUD_BATCH_SIZE"));
        while (size > 0) {
            int x = size >= batchSize ? batchSize : size;
            batches.add(x);
            size -= x;
        }
        int[] result = new int[batches.size()];
        for (int k = 0; k < result.length; ++k) {
            result[k] = (Integer)batches.get(k);
        }
        return result;
    }

    private File getJavaInstallScript() {
        String flavor = this.props.get("JDK_FLAVOR");
        String version = this.props.get("JDK_VERSION");
        String script = "jdk-" + flavor + "-" + version + "-64.sh";
        File scriptDir = new File(STABILIZER_HOME, "jdk-install");
        return new File(scriptDir, script);
    }

    private File getJavaSupportScript() {
        File scriptDir = new File(STABILIZER_HOME, "jdk-install");
        return new File(scriptDir, "jdk-support.sh");
    }

    public void download() {
        this.echoImportant("Download artifacts of %s machines", this.addresses.size());
        this.bash.execute("mkdir -p workers");
        for (AgentAddress address : this.addresses) {
            this.echo("Downloading from %s", address.publicAddress);
            String syncCommand = String.format("rsync  -av -e \"ssh %s\" %s@%s:hazelcast-stabilizer-%s/workers .", this.props.get("SSH_OPTIONS", ""), this.props.get("USER"), address.publicAddress, Utils.getVersion());
            this.bash.execute(syncCommand);
        }
        this.echoImportant("Finished Downloading Artifacts of %s machines", this.addresses.size());
    }

    public void clean() {
        this.echoImportant("Cleaning worker homes of %s machines", this.addresses.size());
        for (AgentAddress address : this.addresses) {
            this.echo("Cleaning %s", address.publicAddress);
            this.bash.ssh(address.publicAddress, String.format("rm -fr hazelcast-stabilizer-%s/workers/*", Utils.getVersion()));
        }
        this.echoImportant("Finished cleaning worker homes of %s machines", this.addresses.size());
    }

    public void terminate() {
        this.terminate(Integer.MAX_VALUE);
    }

    public void terminate(int count) {
        if (count > this.addresses.size()) {
            count = this.addresses.size();
        }
        this.echoImportant(String.format("Terminating %s %s machines (can take some time)", count, this.props.get("CLOUD_PROVIDER")), new Object[0]);
        this.echo("Current number of machines: " + this.addresses.size(), new Object[0]);
        this.echo("Desired number of machines: " + (this.addresses.size() - count), new Object[0]);
        long startMs = System.currentTimeMillis();
        ComputeService compute = new ComputeServiceBuilder(this.props).build();
        for (int batchSize : this.calcBatches(count)) {
            HashMap<String, AgentAddress> terminateMap = new HashMap<String, AgentAddress>();
            for (AgentAddress address : this.addresses.subList(0, batchSize)) {
                terminateMap.put(address.publicAddress, address);
            }
            this.destroyNodes(compute, terminateMap);
        }
        log.info("Updating " + this.agentsFile.getAbsolutePath());
        AgentsFile.save(this.agentsFile, this.addresses);
        long durationSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startMs);
        this.echo("Duration: " + Utils.secondsToHuman(durationSeconds), new Object[0]);
        this.echoImportant("Finished terminating %s %s machines, %s machines remaining.", count, this.props.get("CLOUD_PROVIDER"), this.addresses.size());
    }

    private void destroyNodes(ComputeService compute, final Map<String, AgentAddress> terminateMap) {
        compute.destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata nodeMetadata) {
                for (String publicAddress : nodeMetadata.getPublicAddresses()) {
                    AgentAddress address = (AgentAddress)terminateMap.remove(publicAddress);
                    if (address == null) continue;
                    Provisioner.this.echo(String.format("\t%s Terminating", publicAddress), new Object[0]);
                    Provisioner.this.addresses.remove(address);
                    return true;
                }
                return false;
            }
        });
    }

    private void echo(String s, Object ... args) {
        log.info(s == null ? "null" : String.format(s, args));
    }

    private void echoImportant(String s, Object ... args) {
        this.echo("==============================================================", new Object[0]);
        this.echo(s, args);
        this.echo("==============================================================", new Object[0]);
    }

    public static void main(String[] args) {
        log.info("Hazelcast Stabilizer Provisioner");
        log.info(String.format("Version: %s, Commit: %s, Build Time: %s", Utils.getVersion(), GitInfo.getCommitIdAbbrev(), GitInfo.getBuildTime()));
        log.info(String.format("STABILIZER_HOME: %s", STABILIZER_HOME));
        try {
            Provisioner provisioner = new Provisioner();
            ProvisionerCli cli = new ProvisionerCli(provisioner);
            cli.run(args);
            System.exit(0);
        }
        catch (Throwable e) {
            log.severe(e);
            System.exit(1);
        }
    }

    private class InstallNodeTask
    implements Runnable {
        private final String ip;

        private InstallNodeTask(String ip) {
            this.ip = ip;
        }

        @Override
        public void run() {
            if (!"outofthebox".equals(Provisioner.this.props.get("JDK_FLAVOR"))) {
                Provisioner.this.bash.scpToRemote(this.ip, Provisioner.this.getJavaSupportScript(), "jdk-support.sh");
                Provisioner.this.bash.scpToRemote(this.ip, Provisioner.this.getJavaInstallScript(), "install-java.sh");
                Provisioner.this.bash.ssh(this.ip, "bash install-java.sh");
                Provisioner.this.echo("\t" + this.ip + " JAVA INSTALLED", new Object[0]);
            }
            Provisioner.this.installAgent(this.ip);
            Provisioner.this.echo("\t" + this.ip + " STABILIZER AGENT INSTALLED", new Object[0]);
            Provisioner.this.startAgent(this.ip);
            Provisioner.this.echo("\t" + this.ip + " STABILIZER AGENT STARTED", new Object[0]);
        }
    }
}

