/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.provisioner.Bash;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HazelcastJars {
    private static final ILogger log = Logger.getLogger(HazelcastJars.class);
    private final Bash bash;
    private final String versionSpec;
    private File hazelcastJarsDir;

    public HazelcastJars(Bash bash, String versionSpec) {
        this.bash = bash;
        this.versionSpec = versionSpec;
    }

    public String getAbsolutePath() {
        return this.hazelcastJarsDir.getAbsolutePath();
    }

    public void prepare() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.hazelcastJarsDir = new File(tmpDir, "hazelcastjars-" + UUID.randomUUID().toString());
        this.hazelcastJarsDir.mkdirs();
        log.info("Hazelcast version-spec: " + this.versionSpec);
        if (!this.versionSpec.equals("outofthebox") && !this.versionSpec.equals("bringmyown")) {
            if (this.versionSpec.startsWith("maven=")) {
                String version = this.versionSpec.substring(6);
                this.mavenRetrieve("hazelcast", version);
                this.mavenRetrieve("hazelcast-client", version);
            } else {
                log.severe("Unrecognized version spec:" + this.versionSpec);
                System.exit(1);
            }
        }
    }

    private void mavenRetrieve(String artifact, String version) {
        File userhome = new File(System.getProperty("user.home"));
        File repositoryDir = Utils.newFile(userhome, ".m2", "repository");
        File artifactFile = Utils.newFile(repositoryDir, "com", "hazelcast", artifact, version, String.format("%s-%s.jar", artifact, version));
        if (artifactFile.exists()) {
            log.finest("Using artifact: " + artifactFile + " from local maven repository");
            this.bash.execute(String.format("cp %s %s", artifactFile.getAbsolutePath(), this.hazelcastJarsDir.getAbsolutePath()));
        } else {
            String url;
            log.finest("Artifact: " + artifactFile + " is not found in local maven repository, trying online one");
            if (version.endsWith("-SNAPSHOT")) {
                String baseUrl = "https://oss.sonatype.org/content/repositories/snapshots";
                String mavenMetadataUrl = String.format("%s/com/hazelcast/%s/%s/maven-metadata.xml", baseUrl, artifact, version);
                log.finest("Loading: " + mavenMetadataUrl);
                String mavenMetadata = null;
                try {
                    mavenMetadata = Utils.getText(mavenMetadataUrl);
                }
                catch (FileNotFoundException e) {
                    log.severe("Failed to load " + artifact + "-" + version + ", because :" + mavenMetadataUrl + " was not found");
                    System.exit(1);
                }
                catch (IOException e) {
                    log.severe("Could not load:" + mavenMetadataUrl);
                    System.exit(1);
                }
                log.finest(mavenMetadata);
                String timestamp = this.getTagValue(mavenMetadata, "timestamp");
                String buildnumber = this.getTagValue(mavenMetadata, "buildNumber");
                String shortVersion = version.replace("-SNAPSHOT", "");
                url = String.format("%s/com/hazelcast/%s/%s/%s-%s-%s-%s.jar", baseUrl, artifact, version, artifact, shortVersion, timestamp, buildnumber);
            } else {
                String baseUrl = "http://repo1.maven.org/maven2";
                url = String.format("%s/com/hazelcast/%s/%s/%s-%s.jar", baseUrl, artifact, version, artifact, version);
            }
            this.bash.execute(String.format("wget --no-verbose --directory-prefix=%s %s", this.hazelcastJarsDir.getAbsolutePath(), url));
        }
    }

    private String getTagValue(String mavenMetadata, String tag) {
        Pattern pattern = Pattern.compile("<" + tag + ">(.+?)</" + tag + ">");
        Matcher matcher = pattern.matcher(mavenMetadata);
        if (!matcher.find()) {
            throw new RuntimeException("Could not find " + tag + " in:" + mavenMetadata);
        }
        return matcher.group(1);
    }
}

