/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.google.inject.AbstractModule;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;

public class ComputeServiceBuilder {
    private static final ILogger log = Logger.getLogger(ComputeServiceBuilder.class);
    private final StabilizerProperties props;

    public ComputeServiceBuilder(StabilizerProperties props) {
        if (props == null) {
            throw new NullPointerException("props can't be null");
        }
        this.props = props;
    }

    public ComputeService build() {
        this.ensurePublicPrivateKeyExist();
        String cloudProvider = this.props.get("CLOUD_PROVIDER");
        String identity = this.props.get("CLOUD_IDENTITY");
        String credential = this.props.get("CLOUD_CREDENTIAL");
        if (log.isFinestEnabled()) {
            log.finest("Using CLOUD_PROVIDER: " + cloudProvider);
        }
        ContextBuilder contextBuilder = this.newContextBuilder(cloudProvider);
        return ((ComputeServiceContext)contextBuilder.overrides(this.newOverrideProperties()).credentials(identity, credential).modules(this.getModules()).buildView(ComputeServiceContext.class)).getComputeService();
    }

    private ContextBuilder newContextBuilder(String cloudProvider) {
        try {
            return ContextBuilder.newBuilder((String)cloudProvider);
        }
        catch (NoSuchElementException e) {
            Utils.exitWithError(log, "Unrecognized cloud-provider [" + cloudProvider + "]");
            return null;
        }
    }

    private List<AbstractModule> getModules() {
        return Arrays.asList(new SLF4JLoggingModule(), new SshjSshClientModule());
    }

    private void ensurePublicPrivateKeyExist() {
        File privateKey;
        File publicKey = Utils.newFile("~", ".ssh", "id_rsa.pub");
        if (!publicKey.exists()) {
            Utils.exitWithError(log, "Could not found public key: " + publicKey.getAbsolutePath() + "\n" + "To create a public/private execute [ssh-keygen -t rsa -C \"your_email@example.com\"]");
        }
        if (!(privateKey = Utils.newFile("~", ".ssh", "id_rsa")).exists()) {
            Utils.exitWithError(log, "Public key " + publicKey.getAbsolutePath() + " was found," + " but private key: " + privateKey.getAbsolutePath() + " is missing\n" + "To create a public/private key execute [ssh-keygen -t rsa -C \"your_email@example.com\"]");
        }
    }

    private Properties newOverrideProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.compute.poll-status.initial-period", this.props.get("CLOUD_POLL_INITIAL_PERIOD", "50"));
        properties.setProperty("jclouds.compute.poll-status.max-period", this.props.get("CLOUD_POLL_MAX_PERIOD", "1000"));
        return properties;
    }
}

