/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.provisioner.CloudInfo;
import com.hazelcast.stabilizer.provisioner.ProvisionerCli;
import java.io.File;
import java.io.OutputStream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CloudInfoCli {
    private static final ILogger log = Logger.getLogger(ProvisionerCli.class);
    public final OptionParser parser = new OptionParser();
    public final OptionSpec showLocationsSpec = this.parser.accepts("showLocations", "Shows all locations available. In Amazon for example this would be regions and zones.");
    public final OptionSpec showHardwareSpec = this.parser.accepts("showHardware", "Shows all hardware available");
    public final OptionSpec showImagesSpec = this.parser.accepts("showImages", "Shows all images available");
    public final OptionSpec verboseSpec = this.parser.accepts("verbose", "Shows very detailed info");
    public final OptionSpec<String> locationSpec = this.parser.accepts("location", "The locationId.").withRequiredArg().ofType(String.class);
    public final OptionSpec helpSpec = this.parser.accepts("help", "Show help").forHelp();
    private final OptionSpec<String> propertiesFileSpec = this.parser.accepts("propertiesFile", "The file containing the stabilizer properties. If no file is explicitly configured, first the working directory is checked for a file 'stabilizer.properties'. All missing propertiesare always loaded from STABILIZER_HOME/conf/stabilizer.properties").withRequiredArg().ofType(String.class);
    private final CloudInfo cloudInfo;
    private OptionSet options;

    public CloudInfoCli(CloudInfo cloudInfo) {
        this.cloudInfo = cloudInfo;
    }

    public void run(String[] args) throws Exception {
        try {
            this.options = this.parser.parse(args);
        }
        catch (OptionException e) {
            Utils.exitWithError(log, e.getMessage() + ". Use --help to get overview of the help options.");
            return;
        }
        if (this.options.has(this.helpSpec)) {
            this.parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        this.cloudInfo.props.init(this.getPropertiesFile());
        this.cloudInfo.locationId = (String)this.options.valueOf(this.locationSpec);
        this.cloudInfo.verbose = this.options.has(this.verboseSpec);
        if (this.options.has(this.showLocationsSpec)) {
            this.cloudInfo.init();
            this.cloudInfo.showLocations();
        } else if (this.options.has(this.showHardwareSpec)) {
            this.cloudInfo.init();
            this.cloudInfo.showHardware();
        } else if (this.options.has(this.showImagesSpec)) {
            this.cloudInfo.init();
            this.cloudInfo.showImages();
        } else {
            this.parser.printHelpOn((OutputStream)System.out);
        }
    }

    private File getPropertiesFile() {
        if (this.options.has(this.propertiesFileSpec)) {
            return new File((String)this.options.valueOf(this.propertiesFileSpec));
        }
        return null;
    }
}

