/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.stabilizer.provisioner;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.stabilizer.Utils;
import com.hazelcast.stabilizer.common.StabilizerProperties;
import com.hazelcast.stabilizer.provisioner.CloudInfoCli;
import com.hazelcast.stabilizer.provisioner.ComputeServiceBuilder;
import java.util.Set;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.domain.Location;

public class CloudInfo {
    private static final ILogger log = Logger.getLogger(CloudInfo.class);
    public StabilizerProperties props = new StabilizerProperties();
    private ComputeService computeService;
    public String locationId;
    public boolean verbose;

    public void init() {
        this.computeService = new ComputeServiceBuilder(this.props).build();
    }

    public void showLocations() {
        Set locations = this.computeService.listAssignableLocations();
        for (Location location : locations) {
            System.out.println(location);
        }
    }

    public void showHardware() {
        Set hardwares = this.computeService.listHardwareProfiles();
        for (Hardware hardware : hardwares) {
            Location location;
            if (this.verbose) {
                System.out.println(hardware);
                continue;
            }
            StringBuilder sb = new StringBuilder(hardware.getId());
            sb.append(" Ram: ").append(hardware.getRam());
            sb.append(" Processors: ").append(hardware.getProcessors());
            if (this.locationId == null && (location = hardware.getLocation()) != null) {
                sb.append(" Location: ").append(location.getId());
            }
            System.out.println(sb.toString());
        }
    }

    public void showImages() {
        Set images = this.computeService.listImages();
        for (Image image : images) {
            boolean match = this.show(image);
            if (!match) continue;
            if (this.verbose) {
                System.out.println(image);
                continue;
            }
            StringBuilder sb = new StringBuilder(image.getId());
            sb.append(" OS: ").append(image.getOperatingSystem());
            System.out.println(sb.toString());
        }
    }

    private boolean show(Image image) {
        if (this.locationId == null) {
            return true;
        }
        Location imageLocation = image.getLocation();
        if (imageLocation == null) {
            return true;
        }
        String imageLocationId = imageLocation.getId();
        if (imageLocationId == null) {
            return true;
        }
        return this.locationId.equals(imageLocationId);
    }

    public static void main(String[] args) {
        log.info("Hazelcast Stabilizer CloudInfo");
        log.info(String.format("Version: %s", Utils.getVersion()));
        log.info(String.format("STABILIZER_HOME: %s", Utils.getStablizerHome()));
        try {
            CloudInfo cloudInfoCli = new CloudInfo();
            CloudInfoCli cli = new CloudInfoCli(cloudInfoCli);
            cli.run(args);
            System.exit(0);
        }
        catch (Throwable e) {
            log.severe(e);
            System.exit(1);
        }
    }
}

